/**
 *
 */
package com.foc.task;

import com.foc.fetcher.HCFetcher;
import com.foc.util.DateUtil;
import com.uc.entity.UCImGroupEntity;
import com.uc.service.FOCImGroupService;
import com.uc.service.UCImGroupService;

import java.util.List;

/**
 * # 每小时同步一次华为的群信息
 * 0  *#1  *  *  *  root bash /mnt/foc/project/task/runucgroup.sh
 * 导出文件名称： jd-task-group-2.6.jar
 *
 * @author renmb
 * @version 1.0
 * @team BBDTEK IT Team
 * @time 2017年3月2日
 */
public class UcImGroupTaskMain {

    /**
     * @param args
     * @author renmb
     * @time 2017年3月2日
     */
    public static void main(String[] args) {
        // TODO Auto-generated method stub
        // TODO Auto-generated method stub
        System.out.println("[UcImGroupTaskMain]开始时间[" + DateUtil.getDateTime() + "]");
        long startTime = System.nanoTime();
        try {
            FOCImGroupService focService = new FOCImGroupService();
            UCImGroupService ucService = new UCImGroupService(focService);
            if (args.length > 0) {
                // 通过SQL同步
                String str1 = "SQL";
                String str2 = "SELECT";
                String str3 = "ALL";
                if (str1.equals(args[0])) {

                    if (args[1].startsWith(str2)) {
                        List<UCImGroupEntity> users = ucService.findGroupListBySql(args[1]);
                        System.out.println("本次同步总人数：" + users.size());
                        ucService.handleGroup(users, "SQL");
                    }
                    // 同步所有没有绑定华为账号的用户
                } else if (str3.equals(args[0])) {

                    List<UCImGroupEntity> users = ucService.findGroupList(null);
                    System.out.println("本次同步总人数：" + users.size());
                    ucService.handleGroup(users, "ALL");
                } else {
                    // 同步指定用户ID的用户
                    List<UCImGroupEntity> users = ucService.findGroupList(args);
                    System.out.println("本次同步总人数：" + users.size());
                    ucService.handleGroup(users, "ID");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        System.out.println("[UcImGroupTaskMain]结束时间[" + DateUtil.getDateTime() + "]");
        System.out.println("[UcImGroupTaskMain]总共用时：" + duration + "纳秒");
        System.out.println("[UcImGroupTaskMain]总共用时格式化：" + DateUtil.getDurationTime(duration));
        HCFetcher.getInstance().shutdown();
        System.exit(0);
    }

}
