/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.utils;

import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;

public abstract class StringUtils {
    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isValue(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String hasValue(String value) {
        return StringUtils.isEmpty(value) ? "" : value;
    }

    public static String avoidNull(String value) {
        if (value != null) {
            return value;
        }
        return "";
    }

    public static boolean isNumber(String str) {
        if (str == null) {
            return false;
        }
        str = Normalizer.normalize(str, Normalizer.Form.NFKC);
        return str.matches("\\d+");
    }

    public static boolean isEmptyWihthoutTrim(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isUintNumber(String str) {
        try {
            long uInt = Long.parseLong(str);
            return 0xFFFFFFFFL >= uInt;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String truncateString(String errCode, int length, boolean isRight) {
        if (!StringUtils.isEmpty(errCode)) {
            if (length >= errCode.length()) {
                return errCode;
            }
            String subString = "";
            if (isRight) {
                subString = errCode.substring(0, length);
                return subString;
            }
            subString = errCode.substring(errCode.length() - length, errCode.length());
            return subString;
        }
        return errCode;
    }

    public static String formatNumber(String formatStr, int length, boolean leftPadding, char paddingCharacter) {
        StringBuilder result = new StringBuilder(formatStr);
        String paddingStr = String.valueOf(paddingCharacter);
        while (result.length() < length) {
            if (leftPadding) {
                result = new StringBuilder(paddingStr).append((CharSequence)result);
                continue;
            }
            result.append(paddingCharacter);
        }
        return result.toString();
    }

    public static Map<String, String> parseString(String content, String level1SplitPatten, String level2SplitPatten) {
        String[] tempArray;
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isEmpty(content)) {
            return result;
        }
        String[] stringArray = tempArray = content.split(level1SplitPatten);
        int n = tempArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            String[] tempArray4Item = item.trim().split(level2SplitPatten);
            if (tempArray4Item.length > 1) {
                result.put(tempArray4Item[0].trim(), tempArray4Item[1].trim());
            }
            ++n2;
        }
        return result;
    }

    public static String escapeXMLSymbols(String xmlContent) {
        if (StringUtils.isEmpty(xmlContent)) {
            return xmlContent;
        }
        xmlContent = xmlContent.replaceAll("&", "&amp;");
        xmlContent = xmlContent.replaceAll("<", "&lt;");
        xmlContent = xmlContent.replaceAll(">", "&gt;");
        xmlContent = xmlContent.replaceAll("\"", "&quot;");
        xmlContent = xmlContent.replaceAll("'", "&apos;");
        return xmlContent;
    }

    public static String unescapeXML(String xmlContent) {
        if (!StringUtils.isEmpty(xmlContent)) {
            xmlContent = xmlContent.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'");
        }
        return xmlContent;
    }

    public static String upperCaseFirstLetter(String srcStr) {
        if (StringUtils.isEmpty(srcStr)) {
            return srcStr;
        }
        return String.valueOf(Character.toUpperCase(srcStr.charAt(0))) + srcStr.substring(1);
    }

    public static String lowerCaseFirstLetter(String srcStr) {
        if (StringUtils.isEmpty(srcStr)) {
            return srcStr;
        }
        return String.valueOf(Character.toLowerCase(srcStr.charAt(0))) + srcStr.substring(1);
    }
}

