package com.uc.entity;

import java.util.Date;

/**
 * 华为UC同步信息entity
 * @author lyw
 *
 */
public class UcAccountEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;
	
	private String bindId;  //绑定ID 用户ID或者席位ID
	private String bindType = "USER"; //类型 USER 个人账号 SEAT 席位账号
	private String bindStatus = "FAILD"; //绑定状态 FAILD 绑定失败 SUCCESS 绑定成功 UNBIND 已解绑
	private String huaweiNum; //华为SIP号
	private String huaweiId; //华为UC账号ID
	private String huaweiPassword; //登录华为密码
//	private String updateBy; //最后一次者
	private Date updateDate; //最后一次时间
	private String syncMessage; //同步过程描述

	//同步到录音系统的状态
	private String recordingStatus = "FAILD";

	//同步到录音系统的URL
	private String recordingUrl;
	
	public UcAccountEntity() {
	}
	
	public UcAccountEntity(String bindId) {
		super();
		this.bindId = bindId;
	}

	public UcAccountEntity(String bindId, String bindType) {
		super();
		this.bindId = bindId;
		this.bindType = bindType;
//		this.updateBy = updateBy;
	}

	public String getBindId() {
		return bindId;
	}
	public void setBindId(String bindId) {
		this.bindId = bindId;
	}
	public String getBindType() {
		return bindType;
	}
	public void setBindType(String bindType) {
		this.bindType = bindType;
	}
	public String getBindStatus() {
		return bindStatus;
	}
	public void setBindStatus(String bindStatus) {
		this.bindStatus = bindStatus;
	}
	public String getHuaweiNum() {
		return huaweiNum;
	}
	public void setHuaweiNum(String huaweiNum) {
		this.huaweiNum = huaweiNum;
	}
	public String getHuaweiId() {
		return huaweiId;
	}
	public void setHuaweiId(String huaweiId) {
		this.huaweiId = huaweiId;
	}
	public String getHuaweiPassword() {
		return huaweiPassword;
	}
	public void setHuaweiPassword(String huaweiPassword) {
		this.huaweiPassword = huaweiPassword;
	}
//	public String getUpdateBy() {
//		return updateBy;
//	}
//	public void setUpdateBy(String updateBy) {
//		this.updateBy = updateBy;
//	}
	public Date getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public String getSyncMessage() {
		return syncMessage;
	}

	public void setSyncMessage(String syncMessage) {
		this.syncMessage = syncMessage;
	}

	public String getRecordingStatus() {
		return recordingStatus;
	}

	public void setRecordingStatus(String recordingStatus) {
		this.recordingStatus = recordingStatus;
	}

	public String getRecordingUrl() {
		return recordingUrl;
	}

	public void setRecordingUrl(String recordingUrl) {
		this.recordingUrl = recordingUrl;
	}
}
