package com.foc.conf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;



/**
 * 全局常量表
 * @author Administrator
 *
 */
public class GConstants {
    
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;
    
    // 常用系统属性
    public static final String   LS = System.getProperty("line.separator");// 文本换行符
    public static final String   FS = "/";//System.getProperty("file.separator");// 文件分隔符
    public static final int      BUFFER_SIZE = 8192;// 新建BYTE缓存大小，8*1024;
    public static final String   SEMICOLON   = ";";// 分号
    
    // 文件过滤，
    public final static  Map<String, Boolean> FILE_FILTERS = new HashMap<String, Boolean>(10);
    private static final Properties P = new Properties();// 属性变
    public static final  GConstants C = new GConstants();// 单实体类
    
    // 是|否
    public static final String YES    = "1";
    public static final String NO     = "0";
    public static final String OK     = "OK";
    public static final String EMPTY  = "EMPTY";
    public static final String  FILE_UPLOAD_DIR    = GConstants.getValue("file.upload.dir");// 文件上传地址
    public static final String FOC_BASE_URL            = GConstants.getValue("foc.hrm.base.url");
    public static final String  SIGN_PRIVATE_KEY        = GConstants.getValue("content.sign.private.key", "FvNMhdkN5eTsgAfU2YHGJ2RfpKVi3omn");
    
    public static final String FOC_CC       = GConstants.getValue("ai.cc");// 渠道类型: 1 web，2 app，21 IOS，22 android
    public static final String FOC_CT       = GConstants.getValue("ai.ct");// 渠道号 7 - FOC
    public static final String FOC_CP          = GConstants.getValue("ai.cp");// 授权IP 临时IP地址：10.68.26.52
    public static final int    PAGE_SIZE              = GConstants.getIntValue("pageSize", 1000);
    public static final String FOC_HRM_URL            = FOC_BASE_URL+GConstants.getValue("foc.hrm.url")+"?ai.cc="+FOC_CC+"&ai.ct="+FOC_CT+"&ai.cp="+FOC_CP;
    public static final String FOC_ODS_URL            = FOC_BASE_URL+GConstants.getValue("foc.ods.url")+"?ai.cc="+FOC_CC+"&ai.ct="+FOC_CT+"&ai.cp="+FOC_CP;
    public static final String FOC_ODS_CHANGE_URL     = FOC_BASE_URL+GConstants.getValue("foc.ods.change.url")+"?ai.cc="+FOC_CC+"&ai.ct="+FOC_CT+"&ai.cp="+FOC_CP;
    public static final String FOC_FLIGHT_DYNAMIC_URL = FOC_BASE_URL+GConstants.getValue("foc.flight.dynamic.url")+"?ai.cc="+FOC_CC+"&ai.ct="+FOC_CT+"&ai.cp="+FOC_CP;
    public static final String FOC_FLIGHT_ASSIGNMENT_URL = FOC_BASE_URL+GConstants.getValue("foc.flight.assignment.url")+"?ai.cc="+FOC_CC+"&ai.ct="+FOC_CT+"&ai.cp="+FOC_CP;
    public static final String  FILE_PREFIX_URL    = GConstants.getValue("file.prefix.url");
    public static final String  FOC_SOUND_RECORDS_URL    = GConstants.getValue("foc.sound.records.url");
    public static final int    POLITENESS_DELAY       = GConstants.getIntValue("politeness.delay.seconds", 210);
    
    public static final String  BASE_PATH            = GConstants.getValue("task.base.path");
    public static final boolean DEBUG            = GConstants.getBoolean("is.debug", false);
    
    private GConstants(){
        // 加载基本配置文件
        try {

            File config = new File("ejweb.properties");
            if (config.exists() && config.canRead()) {
                P.load(new BufferedInputStream(new FileInputStream(config)));
            } else {
                P.load(Thread.currentThread().getContextClassLoader()
                        .getResourceAsStream("ejweb.properties"));
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    
    /**
     * 获取属性，以自定义属性优先，然后回去系统属性
     * @param key
     * @return
     */
    public static String getValue(String key) {
        if(key == null)
            return null;
        if (P.containsKey(key)) {
            return P.getProperty(key);
        }
        return System.getProperty(key);
    }
    public static String getValue(String key, String want) {
        String val = getValue(key);
        if(val == null)
            return want;
        return val;
    }
    /**
     * 解析为Boolean类型
     * @param key
     * @param want
     * @return
     */
    public static boolean getBoolean(String key, boolean want) {
        String val = getValue(key);
        if(val == null || val.length() == 0)
            return want;
        try {
            return Boolean.parseBoolean(val);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return want;
    }
    /**
     * 获取整型数据，转换数据类型
     * @param key
     * @param want
     * @return
     */
    public static int getIntValue(String key, int want) {
        String val = getValue(key);
        if(val == null || val.length() == 0)
            return want;
        try {
            return Integer.parseInt(val);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return want;
    }
    /**
     * 获取长整型数据
     * @param key
     * @param want
     * @return
     */
    public static long getLongValue(String key, long want) {
        String val = getValue(key);
        if(val == null || val.length() == 0)
            return want;
        try {
            return Long.parseLong(val);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return want;
    }
    public static float getFloatValue(String key, float want) {
        String val = getValue(key);
        if(val == null || val.length() == 0)
            return want;
        try {
            return Float.parseFloat(val);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return want;
    }
    public static double getDoubleValue(String key, double want) {
        String val = getValue(key);
        if(val == null || val.length() == 0)
            return want;
        try {
            return Double.parseDouble(val);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return want;
    }
}
