/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PropertiesUtils {
    private static final Logger LOGGER = Logger.getLogger(PropertiesUtils.class.getName());
    private static Properties properties = null;

    static {
        properties = PropertiesUtils.loadProperty();
    }

    private static Properties loadProperty() {
        Properties p = new Properties();
        PropertiesUtils.loadProp("rest_config.properties", p);
        PropertiesUtils.loadProp("esdk_ec_config.properties", p);
        return p;
    }

    private static void loadProp(String conf, Properties p) {
        block12: {
            InputStream is = null;
            try {
                try {
                    is = PropertiesUtils.getInputStream(conf);
                    p.load(is);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Exception happened in loadProp() " + conf, e);
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        LOGGER.log(Level.WARNING, "Exception happened in loadProperty()" + conf, e2);
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Exception happened in loadProperty()" + conf, e);
                    }
                }
            }
        }
    }

    public static String getValue(String key) {
        String value = properties.getProperty(key);
        return value == null ? "" : value;
    }

    private static InputStream getInputStream(String path) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException(String.valueOf(path) + " cannot be opened because it does not exist");
        }
        return is;
    }
}

