/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.utils;

import com.huawei.esdk.uc.professional.local.utils.AES128Utils;
import com.huawei.esdk.uc.professional.local.utils.AESCbc128Utils;
import com.huawei.esdk.uc.professional.local.utils.Base64Utils;
import com.huawei.esdk.uc.professional.local.utils.PropertiesUtils;
import com.huawei.esdk.uc.professional.local.utils.RSA2048Utils;
import com.huawei.esdk.uc.professional.local.utils.StringUtils;

public abstract class Encrypt {
    public static String getEncryptPwd(String pwd) throws Exception {
        String transmissionMode = PropertiesUtils.getValue("sensitive.information.transmission.mode");
        String result = null;
        if (StringUtils.isEmpty(pwd)) {
            return pwd;
        }
        result = "RSA2048".equalsIgnoreCase(transmissionMode) ? Base64Utils.encode(RSA2048Utils.encode(pwd.getBytes("UTF-8"))) : ("AES128_fixed".equalsIgnoreCase(transmissionMode) ? Base64Utils.encode(AESCbc128Utils.encode(pwd.getBytes("UTF-8"))) : ("Plaintext".equalsIgnoreCase(transmissionMode) ? pwd : Base64Utils.encode(AES128Utils.encode(pwd.getBytes("UTF-8")))));
        return result;
    }

    public static String getDecryptPwd(String pwd) throws Exception {
        String transmissionMode = PropertiesUtils.getValue("sensitive.information.transmission.mode");
        if (StringUtils.isEmpty(pwd)) {
            return pwd;
        }
        if ("AES128_consulted".equalsIgnoreCase(transmissionMode)) {
            return new String(AES128Utils.decode(Base64Utils.getFromBASE64(pwd)), "UTF-8");
        }
        if ("AES128_fixed".equalsIgnoreCase(transmissionMode)) {
            return new String(AESCbc128Utils.decode(Base64Utils.getFromBASE64(pwd)), "UTF-8");
        }
        return pwd;
    }
}

