/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.resource;

import com.google.gson.Gson;
import com.huawei.esdk.uc.professional.local.bean.RestRequestMessage;
import com.huawei.esdk.uc.professional.local.bean.south.SipQueryRequest;
import com.huawei.esdk.uc.professional.local.bean.south.SipQueryResponse;
import com.huawei.esdk.uc.professional.local.bean.south.SipRequest;
import com.huawei.esdk.uc.professional.local.bean.south.SipResponse;
import com.huawei.esdk.uc.professional.local.utils.PropertiesUtils;
import com.huawei.esdk.uc.professional.local.utils.RestUtils;
import com.huawei.esdk.uc.professional.local.utils.StringUtils;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SIPAccountResource {
    private static final Logger LOGGER = Logger.getLogger(SIPAccountResource.class);
    private static final Gson GSON = new Gson();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipResponse addSIP(SipRequest acct) {
        SipResponse result = null;
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("POST");
        restRequestMessage.setPayload(acct);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("sip.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if (!"401".equals(responsePayload)) return (SipResponse)GSON.fromJson(responsePayload, SipResponse.class);
                result = new SipResponse();
                result.setResultCode("401");
            } else {
                result = new SipResponse();
                result.setResultCode(String.valueOf(1));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("addDepartment error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("addDepartment error" + e));
        }
        result = new SipResponse();
        result.setResultCode(String.valueOf(1));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipResponse modifySIP(SipRequest acct) {
        SipResponse result = null;
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("PUT");
        restRequestMessage.setPayload(acct);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("sip.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if (!"401".equals(responsePayload)) return (SipResponse)GSON.fromJson(responsePayload, SipResponse.class);
                result = new SipResponse();
                result.setResultCode("401");
            } else {
                result = new SipResponse();
                result.setResultCode(String.valueOf(1));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("addDepartment error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("addDepartment error" + e));
        }
        result = new SipResponse();
        result.setResultCode(String.valueOf(1));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipResponse deleteSip(SipRequest acct) {
        SipResponse result = null;
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("POST");
        restRequestMessage.setPayload(acct);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("delete_sip.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if (!"401".equals(responsePayload)) return (SipResponse)GSON.fromJson(responsePayload, SipResponse.class);
                result = new SipResponse();
                result.setResultCode("401");
            } else {
                result = new SipResponse();
                result.setResultCode(String.valueOf(1));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("deleteSip error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("deleteSip error" + e));
        }
        result = new SipResponse();
        result.setResultCode(String.valueOf(1));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SipQueryResponse querySip(SipQueryRequest sip) {
        SipQueryResponse result = null;
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("POST");
        restRequestMessage.setPayload(sip);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("query_sip.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if (!"401".equals(responsePayload)) return (SipQueryResponse)GSON.fromJson(responsePayload, SipQueryResponse.class);
                result = new SipQueryResponse();
                result.setResultCode("401");
            } else {
                result = new SipQueryResponse();
                result.setResultCode(String.valueOf(1));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("deleteSip error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("deleteSip error" + e));
        }
        result = new SipQueryResponse();
        result.setResultCode(String.valueOf(1));
        return result;
    }
}

