/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http.stat;

import com.alibaba.druid.support.http.stat.WebAppStat;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class WebAppStatUtils {
    private static final Log LOG = LogFactory.getLog(WebAppStatUtils.class);

    public static Map<String, Object> getStatData(Object webStat) {
        if (webStat.getClass() == WebAppStat.class) {
            return ((WebAppStat)webStat).getStatData();
        }
        try {
            Method method = webStat.getClass().getMethod("getStatData", new Class[0]);
            Object obj = method.invoke(webStat, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getStatData error", e);
            return null;
        }
    }

    public static List<Map<String, Object>> getURIStatDataList(Object webStat) {
        if (webStat.getClass() == WebAppStat.class) {
            return ((WebAppStat)webStat).getURIStatDataList();
        }
        try {
            Method method = webStat.getClass().getMethod("getURIStatDataList", new Class[0]);
            Object obj = method.invoke(webStat, new Object[0]);
            return (List)obj;
        }
        catch (Exception e) {
            LOG.error("getURIStatDataList error", e);
            return null;
        }
    }

    public static List<Map<String, Object>> getSessionStatDataList(Object webStat) {
        if (webStat.getClass() == WebAppStat.class) {
            return ((WebAppStat)webStat).getSessionStatDataList();
        }
        try {
            Method method = webStat.getClass().getMethod("getSessionStatDataList", new Class[0]);
            Object obj = method.invoke(webStat, new Object[0]);
            return (List)obj;
        }
        catch (Exception e) {
            LOG.error("getSessionStatDataList error", e);
            return null;
        }
    }

    public static Map<String, Object> getSessionStatData(Object webStat, String sessionId) {
        if (webStat.getClass() == WebAppStat.class) {
            return ((WebAppStat)webStat).getSessionStatData(sessionId);
        }
        try {
            Method method = webStat.getClass().getMethod("getSessionStatData", String.class);
            Object obj = method.invoke(webStat, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getSessionStatData error", e);
            return null;
        }
    }

    public static Map<String, Object> getURIStatData(Object webStat, String uri) {
        if (webStat.getClass() == WebAppStat.class) {
            return ((WebAppStat)webStat).getURIStatData(uri);
        }
        try {
            Method method = webStat.getClass().getMethod("getURIStatData", String.class);
            Object obj = method.invoke(webStat, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getURIStatData error", e);
            return null;
        }
    }

    public static void reset(Object webStat) {
        if (webStat.getClass() == WebAppStat.class) {
            ((WebAppStat)webStat).reset();
            return;
        }
        try {
            Method method = webStat.getClass().getMethod("reset", new Class[0]);
            method.invoke(webStat, new Object[0]);
        }
        catch (Exception e) {
            LOG.error("reset error", e);
        }
    }
}

