/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseExceptions;
import java.io.IOException;
import java.io.Reader;

public class BaseCharacterStreamWrapper
extends Reader {
    private static String footprint = "$Revision:   1.8.1.0  $";
    BaseConnection connection;
    Object synchronizer;
    Reader rdr;
    boolean closed;
    long numTotalCharsInReader;
    long numCharsReturned;
    long maxCharsToReturn = Long.MAX_VALUE;
    BaseExceptions exceptions;
    boolean isOutputStream = true;

    BaseCharacterStreamWrapper(Reader reader, long l, BaseConnection baseConnection, BaseExceptions baseExceptions) {
        this.rdr = reader;
        this.exceptions = baseExceptions;
        this.numTotalCharsInReader = l;
        this.numCharsReturned = 0L;
        this.closed = false;
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.rdr.close();
                this.closed = true;
            }
        }
    }

    public long length() {
        return this.numTotalCharsInReader;
    }

    public synchronized void mark(int n) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.rdr.mark(n);
            }
        }
    }

    public boolean markSupported() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                boolean bl = this.rdr.markSupported();
                Object var3_4 = null;
                return bl;
            }
            boolean bl = false;
            Object var3_5 = null;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numCharsReturned == this.maxCharsToReturn) {
                return -1;
            }
            int n = this.rdr.read();
            if (this.numTotalCharsInReader == -1L) return n;
            boolean bl = false;
            if (n != -1) {
                ++this.numCharsReturned;
                if (this.numCharsReturned > this.numTotalCharsInReader) {
                    return -2;
                }
            } else if (this.numCharsReturned != this.numTotalCharsInReader) {
                return -2;
            }
            if (!bl) return n;
            return -2;
        }
    }

    public int read(char[] cArray) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            int n = this.read(cArray, 0, cArray.length);
            Object var4_4 = null;
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numCharsReturned == this.maxCharsToReturn) {
                return -1;
            }
            if (cArray.length - n < n2) {
                throw new IOException(this.exceptions.getException(6066).getMessage());
            }
            if (this.numCharsReturned + (long)n2 > this.maxCharsToReturn) {
                n2 = new Long(this.maxCharsToReturn - this.numCharsReturned).intValue();
            }
            int n3 = this.rdr.read(cArray, n, n2);
            if (this.numTotalCharsInReader == -1L) return n3;
            boolean bl = false;
            if (n3 != -1) {
                this.numCharsReturned += (long)n3;
                if (this.numCharsReturned > this.numTotalCharsInReader) {
                    return -2;
                }
            } else if (this.numCharsReturned != this.numTotalCharsInReader) {
                return -2;
            }
            if (!bl) return n3;
            return -2;
        }
    }

    public synchronized void reset() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            this.rdr.reset();
        }
    }

    void setConnection(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.synchronizer = baseConnection;
    }

    void setIsInputStream() {
        this.isOutputStream = false;
    }

    public long skip(long l) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            long l2 = this.rdr.skip(l);
            Object var6_4 = null;
            return l2;
        }
    }

    void validateClosedState() throws IOException {
        if (this.closed || this.connection != null && this.connection.isClosed()) {
            throw new IOException(this.exceptions.getException(6010).getMessage());
        }
    }
}

