/**
 *
 */
package com.foc.task;

import com.foc.fetcher.HCFetcher;
import com.foc.util.DateUtil;
import com.uc.entity.SeatEntity;
import com.uc.entity.UserProfileEntity;
import com.uc.service.UCUserService;

import java.util.List;

/**
 * # 每天凌晨1点同步用户数据
 * 1  *  *  * root bash /mnt/foc/project/task/runhrmtask.sh
 * 导出文件名称： jd-task-hrm-2.6.jar
 *
 * @author renmb
 * @version 1.0
 * @team IT Team
 * @time 2017年1月17日
 */
public class UcUserTaskMain {

    /**
     * @param args
     * @author renmb
     * @time 2017年1月17日
     */
    public static void main(String[] args) {
        // TODO Auto-generated method stub
        System.out.println("[UcUserTaskMain]开始时间[" + DateUtil.getDateTime() + "]");
        long startTime = System.nanoTime();
        try {
            UCUserService service = new UCUserService();
            String str1 = "SQL";
            String str2 = "SELECT";
            String str3 = "ALL";
            if (args.length > 0) {
                // 通过SQL同步
                if (str1.equals(args[0])) {

                    if (args[1].startsWith(str2)) {
                        List<UserProfileEntity> users = service.findUserListBySql(args[1]);
                        System.out.println("本次同步总人数：" + users.size());
                        service.addAccountToUc(users);
                        // 同步指定用户ID的用户
                        List<SeatEntity> seatList = service.findSeatListBySql(args[1]);
                        System.out.println("本次同步总席位数：" + seatList.size());
                        service.addSeatAccountToUc(seatList);
                    }
                    // 同步所有没有绑定华为账号的用户
                } else if (str3.equals(args[0])) {

                    List<UserProfileEntity> users = service.findUserList(null);
                    System.out.println("本次同步总人数：" + users.size());
                    service.addAccountToUc(users);
                    // 同步指定用户ID的用户
                    List<SeatEntity> seatList = service.findSeatList(null);
                    System.out.println("本次同步总席位数：" + seatList.size());
                    service.addSeatAccountToUc(seatList);
                } else {
                    // 同步指定用户ID的用户
                    List<UserProfileEntity> users = service.findUserList(args);
                    System.out.println("本次同步总人数：" + users.size());
                    service.addAccountToUc(users);
                    // 同步指定用户ID的用户
                    List<SeatEntity> seatList = service.findSeatList(args);
                    System.out.println("本次同步总席位数：" + seatList.size());
                    service.addSeatAccountToUc(seatList);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        System.out.println("[UcUserTaskMain]结束时间[" + DateUtil.getDateTime() + "]");
        System.out.println("[UcUserTaskMain]总共用时：" + duration + "纳秒");
        System.out.println("[UcUserTaskMain]总共用时格式化：" + DateUtil.getDurationTime(duration));
        HCFetcher.getInstance().shutdown();
        System.exit(0);
    }

}
