/**
 *
 */
package com.foc.phone.area;

import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foc.conf.GConstants;
import com.foc.fetcher.FetchEntity;
import com.foc.fetcher.HCFetcher;
import com.foc.util.DateUtil;

/**
 * 
 * @team IT Team
 * @author renmb
 * @version 1.0
 * @time  2016年10月30日
 */
public class PhoneAreaUtil {

    /**
     * 更加360的接口查询归属地
     * 
     * @author renmb
     * @time  2016年10月30日
     * @param phone
     * @return
     */
    public static PhoneAreaEntity get360PhoneArea(String mobile){
        try {
            if(StringUtils.isBlank(mobile))
                return null;
            HCFetcher fetcher = HCFetcher.getInstance();
            FetchEntity entity = fetcher.get("http://cx.shouji.360.cn/phonearea.php?number="+mobile);
            if(entity != null && entity.isSuccess()){
                
                String txt = entity.getContent("UTF-8");
                if(GConstants.DEBUG){
                    
                    System.out.println("http://cx.shouji.360.cn/phonearea.php?number="+mobile);
                    System.out.println("返回: "+txt);
                }
                JSONObject object = JSON.parseObject(txt);
                JSONObject data = object.getJSONObject("data");
                
                if(StringUtils.isNotBlank(data.getString("province"))){
                    
                    PhoneAreaEntity area = new PhoneAreaEntity();
                    area.setProvince(data.getString("province"));
                    area.setCity(data.getString("city"));
                    area.setSp(data.getString("sp"));
                    
                    return area;
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
        }
        return null;
    }
    public static void main(String[] args) {
        // TODO Auto-generated method stub
        System.out.println("[PhoneAreaUtil]开始时间[" + DateUtil.getDateTime() + "]");
        long startTime = System.nanoTime();
        for(int i=0;i<10;i++){
            
            RandomUtils.nextLong(300, 700);
            String phone = "1"+String.format("%05d", RandomUtils.nextLong(0, 99999))+String.format("%05d", RandomUtils.nextLong(0, 99999));
            
            
            System.out.print(PhoneAreaUtil.get360PhoneArea("15281139"+RandomUtils.nextLong(100, 999)));
        }
        
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        System.out.println("[PhoneAreaUtil]结束时间[" + DateUtil.getDateTime() + "]");
        System.out.println("[PhoneAreaUtil]总共用时：" + duration + "纳秒");
        System.out.println("[PhoneAreaUtil]总共用时格式化：" + DateUtil.getDurationTime(duration));
        
        System.out.println("[PhoneAreaUtil]========================");
        duration = (endTime - startTime)/100;
        System.out.println("[PhoneAreaUtil]结束时间[" + DateUtil.getDateTime() + "]");
        System.out.println("[PhoneAreaUtil]总共用时：" + duration + "纳秒");
        System.out.println("[PhoneAreaUtil]总共用时格式化：" + DateUtil.getDurationTime(duration));
        HCFetcher.getInstance().shutdown();
        System.exit(0);
    }
}
