/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.resource;

import com.google.gson.Gson;
import com.huawei.esdk.uc.professional.local.bean.RestErrCode;
import com.huawei.esdk.uc.professional.local.bean.RestRequestMessage;
import com.huawei.esdk.uc.professional.local.bean.south.AddDepartmentResponse;
import com.huawei.esdk.uc.professional.local.bean.south.DepartmentRequest;
import com.huawei.esdk.uc.professional.local.bean.south.QueryDepartmentResponse;
import com.huawei.esdk.uc.professional.local.utils.PropertiesUtils;
import com.huawei.esdk.uc.professional.local.utils.RestUtils;
import com.huawei.esdk.uc.professional.local.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DepartmentResource {
    private static final Logger LOGGER = Logger.getLogger(DepartmentResource.class);
    private static final Gson GSON = new Gson();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AddDepartmentResponse addDepartment(DepartmentRequest departmentRequest) {
        AddDepartmentResponse result = null;
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("POST");
        restRequestMessage.setPayload(departmentRequest);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("department.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if (!"401".equals(responsePayload)) return (AddDepartmentResponse)GSON.fromJson(responsePayload, AddDepartmentResponse.class);
                result = new AddDepartmentResponse();
                result.setResultCode("401");
            } else {
                result = new AddDepartmentResponse();
                result.setResultCode(String.valueOf(1));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("addDepartment error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("addDepartment error" + e));
        }
        result = new AddDepartmentResponse();
        result.setResultCode(String.valueOf(1));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RestErrCode modifyDepartment(DepartmentRequest departmentRequest) {
        RestErrCode result = null;
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("PUT");
        restRequestMessage.setPayload(departmentRequest);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("department.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if (!"401".equals(responsePayload)) return (RestErrCode)GSON.fromJson(responsePayload, RestErrCode.class);
                result = new RestErrCode();
                result.setResultCode("401");
            } else {
                result = new RestErrCode();
                result.setResultCode(String.valueOf(1));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("modifyDepartment error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("modifyDepartment error" + e));
        }
        result = new RestErrCode();
        result.setResultCode(String.valueOf(1));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RestErrCode deleteDepartment(String userId, String departmentId) {
        RestErrCode result = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("departmentId", departmentId);
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("DELETE");
        restRequestMessage.setParameters(parameters);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("department.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if (!"401".equals(responsePayload)) return (RestErrCode)GSON.fromJson(responsePayload, RestErrCode.class);
                result = new RestErrCode();
                result.setResultCode("401");
            } else {
                result = new RestErrCode();
                result.setResultCode(String.valueOf(1));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("deleteDepartment error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("deleteDepartment error" + e));
        }
        result = new RestErrCode();
        result.setResultCode(String.valueOf(1));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QueryDepartmentResponse queryDepartment(String userId, String parentId, String pageCount, String pageNum) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("parentId", parentId);
        parameters.put("pageCount", pageCount);
        parameters.put("pageNum", pageNum);
        QueryDepartmentResponse result = null;
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("GET");
        restRequestMessage.setParameters(parameters);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("department.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if (!"401".equals(responsePayload)) return (QueryDepartmentResponse)GSON.fromJson(responsePayload, QueryDepartmentResponse.class);
                result = new QueryDepartmentResponse();
                result.setResultCode("401");
            } else {
                result = new QueryDepartmentResponse();
                result.setResultCode(String.valueOf(1));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("queryEnterprise error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("queryEnterprise error" + e));
        }
        result = new QueryDepartmentResponse();
        result.setResultCode(String.valueOf(1));
        return result;
    }
}

