/**
 *
 */
package com.uc.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang3.StringUtils;

import com.foc.conf.GConstants;
import com.foc.util.DBHelper;
import com.foc.util.Util;
import com.uc.entity.FOCImGroupEntity;
import com.uc.entity.UCImGroupEntity;
import com.uc.entity.UCImGroupUserEntity;
import com.uc.entity.UserProfileEntity;

/**
 * 
 * @team BBDTEK IT Team
 * @author renmb
 * @version 1.0
 * @time  2017年3月2日
 */
public class UCImGroupService {

    private FOCImGroupService focService;
    public UCImGroupService(FOCImGroupService focService){
        
        this.focService = focService;
    }
    public void handleGroup(List<UCImGroupEntity> groupList, String type) {
        
        if(groupList == null || groupList.size() == 0)
            return ;
//        int countGroup = 0;
//        int countGroupState = 0;
        int size = groupList.size();
        int i =1;
        if("ALL".equals(type)){// 全部
            
            List<String> groupIdList = new ArrayList<String>();
            for (UCImGroupEntity ucGroup:groupList) {
                if(StringUtils.isNotEmpty(ucGroup.getId())){
                    
                    groupIdList.add(ucGroup.getId());
                }
            }
            focService.deleteGroupNotInId(groupIdList);
        }
        Map<String, FOCImGroupEntity> focGroupList = focService.findAllGroupListToMap();
        for (UCImGroupEntity ucGroup:groupList) {
            
            System.out.println("--GROUP ROW: "+i+"/"+size+"--【"+ucGroup.getId()+"】【"+ucGroup.getName()+"】");
            
            List<UCImGroupUserEntity> ucGroupUserList = this.findGroupUserList(ucGroup.getId());
            
            focService.updateGroup(focGroupList.get(ucGroup.getId()), ucGroup, ucGroupUserList);
            
//            if("0".equals(ucGroup.getState())){// 只修改群头像
//                
//                String status = Util.updateGroupAvatar(ucGroup.getId(), ucGroup.getStaffaccount());
//                System.out.println("【"+ucGroup.getId()+"】【"+ucGroup.getName()+"】【updateGroupAvatar】【"+status+"】");
//            }
            i++;
        }
//        System.out.println("FOC系统不存在此群组总个数: "+countGroup);
//        System.out.println("状态不一致总个数: "+countGroupState);
    }
//    public void handleGroupUser(String groupid) {
//        
//        List<UCImGroupUserEntity> groupUserList = this.findGroupUserList(groupid);
//        this.handleGroupUser(groupUserList);
//    }
//    public void handleGroupUser(List<UCImGroupUserEntity> groupUserList) {
//        if(groupUserList == null || groupUserList.size() == 0)
//            return ;
//        int i =1;
//        for (UCImGroupUserEntity group:groupUserList) {
//            System.out.println("----------GROUP USER ROW: "+i+"--------------");
//            System.out.println("GU.ID: "+group.getId());
//            System.out.println("GU.GROUPID: "+group.getGroupid());
//            System.out.println("GU.USERID: "+group.getUserid());
//            System.out.println("GU.STATE: "+group.getState());
//            System.out.println("U.STAFFACCOUNT: "+group.getStaffaccount());
//            System.out.println("U.STAFFNAME: "+group.getStaffname());
//            i++;
//        }
//    }
    /**
     * 查询群组列表
     * 
     * @author renmb
     * @time  2017年3月14日
     * @param sql
     * @return
     */
    public List<UCImGroupEntity> findGroupListBySql(String sql) {
        try {
            ResultSetHandler<List<UCImGroupEntity>> handler = new BeanListHandler<UCImGroupEntity>(UCImGroupEntity.class);
            List<UCImGroupEntity> list = null;
            QueryRunner run = new QueryRunner(DBHelper.getDataSource("ucdb"));
//            System.out.println(sql);
            list = run.query(sql, handler);
            if (list != null && list.size() > 0) {

                return list;
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return null;
    }
    /**
     * 查询群组列表
     * 
     * @author renmb
     * @time  2017年3月14日
     * @param ids
     * @return
     */
    public List<UCImGroupEntity> findGroupList(Object[] ids) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT G.ID, ");
            builder.append("       G.NAME, ");
            builder.append("       G.STATE, ");
            builder.append("       G.CREATETIME, ");
            builder.append("       G.OWNERID, ");
            builder.append("       U.STAFFACCOUNT, ");
            builder.append("       U.STAFFNAME  ");
            builder.append("FROM EGROUP_IMGROUP G ");
            builder.append("LEFT JOIN EGROUP_STAFFTAB U ");
            builder.append("  ON G.OWNERID=U.STAFFID ");
            
            if(ids != null && ids.length>0){
                builder.append("WHERE G.ID IN ( ");
                for(int i=0,len=ids.length;i<len;i++){
                    if(i == 0){
                        builder.append("?");
                    } else{
                        builder.append(", ?");
                    }
                }
                builder.append(" ) ");
            }
            ResultSetHandler<List<UCImGroupEntity>> handler = new BeanListHandler<UCImGroupEntity>(UCImGroupEntity.class);
            List<UCImGroupEntity> list = null;
            QueryRunner run = new QueryRunner(DBHelper.getDataSource("ucdb"));
//            System.out.println(builder.toString());
            if(ids != null && ids.length>0){
                list = run.query(builder.toString(), handler, ids);
            } else {
                list = run.query(builder.toString(), handler);
            }
            if (list != null && list.size() > 0) {

                return list;
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return null;
    }
    /**
     * 查询群组的用户列表
     * 
     * @author renmb
     * @time  2017年3月14日
     * @param groupid
     * @return
     */
    public List<UCImGroupUserEntity> findGroupUserList(String groupid) {
        try {
            if(groupid == null || groupid.length() == 0){
                
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT GU.ID, ");
            builder.append("       GU.GROUPID, ");
            builder.append("       GU.USERID, ");
            builder.append("       GU.STATE, ");
            builder.append("       U.STAFFACCOUNT, ");
            builder.append("       U.STAFFNAME  ");
            builder.append("FROM EGROUP_IMGROUPUSER GU ");
            builder.append("LEFT JOIN EGROUP_STAFFTAB U ");
            builder.append("  ON GU.USERID=U.STAFFID ");
            
            builder.append("WHERE GU.GROUPID = ? ");
            
            ResultSetHandler<List<UCImGroupUserEntity>> handler = new BeanListHandler<UCImGroupUserEntity>(UCImGroupUserEntity.class);
            List<UCImGroupUserEntity> list = null;
            QueryRunner run = new QueryRunner(DBHelper.getDataSource("ucdb"));
//            System.out.println(builder.toString());
            list = run.query(builder.toString(), handler, groupid);
            
            if (list != null && list.size() > 0) {

                return list;
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return null;
    }
}
