/**
 *
 */
package com.foc.task;

import java.util.List;

import com.foc.fetcher.HCFetcher;
import com.foc.util.DateUtil;
import com.uc.entity.UCImGroupEntity;
import com.uc.entity.UserProfileEntity;
import com.uc.service.FOCImGroupService;
import com.uc.service.UCImGroupService;
import com.uc.service.UCUserService;

/**
 * # 每小时同步一次华为的群信息
 * 0  *#1  *  *  *  root bash /mnt/foc/project/task/runucgroup.sh
 * 导出文件名称： jd-task-group-2.6.jar
 * 
 * @team BBDTEK IT Team
 * @author renmb
 * @version 1.0
 * @time  2017年3月2日
 */
public class UCImGroupTaskMain {

    /**
     * 
     * @author renmb
     * @time  2017年3月2日
     * @param args
     */
    public static void main(String[] args) {
        // TODO Auto-generated method stub
        // TODO Auto-generated method stub
        System.out.println("[UCImGroupTaskMain]开始时间[" + DateUtil.getDateTime() + "]");
        long startTime = System.nanoTime();
        try {
            FOCImGroupService focService = new FOCImGroupService();
            UCImGroupService ucService = new UCImGroupService(focService);
            if(args.length>0){
                if("SQL".equals(args[0])){// 通过SQL同步
                    
                    if(args[1].startsWith("SELECT")){
                        List<UCImGroupEntity> users = ucService.findGroupListBySql(args[1]);
                        System.out.println("本次同步总人数："+users.size());
                        ucService.handleGroup(users, "SQL");
                    }
                } else if("ALL".equals(args[0])){// 同步所有没有绑定华为账号的用户
                    
                    List<UCImGroupEntity> users = ucService.findGroupList(null);
                    System.out.println("本次同步总人数："+users.size());
                    ucService.handleGroup(users, "ALL");
                } else {
                    
                    List<UCImGroupEntity> users = ucService.findGroupList(args);// 同步指定用户ID的用户
                    System.out.println("本次同步总人数："+users.size());
                    ucService.handleGroup(users, "ID");
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        System.out.println("[UCImGroupTaskMain]结束时间[" + DateUtil.getDateTime() + "]");
        System.out.println("[UCImGroupTaskMain]总共用时：" + duration + "纳秒");
        System.out.println("[UCImGroupTaskMain]总共用时格式化：" + DateUtil.getDurationTime(duration));
        HCFetcher.getInstance().shutdown();
        System.exit(0);
    }

}
