/**
 *
 */
package com.foc.task;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import com.foc.conf.HistoryConfig;
import com.foc.plan.push.service.PlanPushService;
import com.foc.util.DateUtil;

/**
 * # 签到推送
 * *#1  5-23  *  *  * root bash /mnt/foc/project/task/runpushtask.sh
 * 导出文件名称： jd-task-push-2.6.jar
 * 
 * @team BBDTEK IT Team
 * @author renmb
 * @version 1.0
 * @time 2016年12月17日
 */
public class PlanPushTaskMain {
    public static void main(String[] args) {
//        System.out.println(String.format("%02d", 2));System.exit(0);
        // System.out.println(DateUtil.getDateTime().replaceAll("[-|:|\\s]",
        // "")+".json");
        // System.exit(0);
        // Logger logger = Logger.getLogger(BefBasicArchiveMain.class);
        boolean isForce = false;
        if((args != null && args.length >= 1 && "F".equals((args[args.length-1])))){
            System.out.println("[PlanPushTaskMain]强制模式");
            isForce = true;
        }
        final String key = "push.task.is.running";
        if (!isForce && HistoryConfig.getInt(key, 0) == 1) {
            System.out.println("[PlanPushTaskMain]上次程序正在运行！跳过本次运行。。。");
            return;
        }
        if (!isForce && HistoryConfig.getInt("all.task.is.running", 0) == 1) {
            System.out.println("[PlanPushTaskMain][ALL]上次程序正在运行！跳过本次运行。。。");
            return;
        }
        if (!isForce && HistoryConfig.getInt("daily.task.is.running", 0) == 1) {
            System.out.println("[PlanPushTaskMain][DAILY]上次程序正在运行！跳过本次运行。。。");
            return;
        }
        HistoryConfig.put("push.task.last.time", DateUtil.getDateTime());
        HistoryConfig.put(key, "1");
        HistoryConfig.saveHistory();
        long startTime = System.nanoTime();

        final String flightDate = DateUtil.getDateTime();
        System.out.println("[PlanPushTaskMain]开始时间[" + flightDate + "]");

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        final String modified = sdf.format(new Date());
        System.out.println("[PlanPushTaskMain][修改时间]" + modified);
        // TODO Auto-generated method stub
        final ExecutorService threadPool = Executors.newCachedThreadPool();

        threadPool.execute(new Runnable() {// 5.1 ODS飞行计划接口（亦即机组排班接口）

            @Override
            public void run() {

                final String flightDate = DateUtil.dateToStr(new Date(), DateUtil.DATE_FORMAT);
                PlanPushService service = new PlanPushService();
                service.handle(flightDate, modified);
            }
        });
        threadPool.shutdown();
        
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        System.out.println("[PlanPushTaskMain]总共用时：" + duration + "纳秒");
        System.out.println("[PlanPushTaskMain]总共用时格式化：" + DateUtil.getDurationTime(duration));
        HistoryConfig.put(key, "0");
        HistoryConfig.saveHistory();
    }
}
