/**
 *
 */
package com.foc.task;

import java.text.SimpleDateFormat;
import java.util.Date;

import com.foc.conf.HistoryConfig;
import com.foc.fetcher.HCFetcher;
import com.foc.hrm.service.HRMUpdatePreMobileService;
import com.foc.util.DateUtil;

/**
 * # 格式化手机号和座机号
 * 1  2  *  *  * root bash /mnt/foc/project/task/runupdatehrmtask.sh
 * 导出文件名称： jd-task-hrm-update-2.0.jar
 * 
 * @team IT Team
 * @author renmb
 * @version 1.0
 * @time  2016年10月30日
 */
public class HRMUpdateTaskMain {

    /**
     * 
     * @author renmb
     * @time  2016年10月30日
     * @param args
     */
    public static void main(String[] args) {
        // TODO Auto-generated method stub
        final String key = "hrm.premobile.task.is.running";
        if (HistoryConfig.getInt(key, 0) == 1) {
            System.out.println("[HRMUpdateTaskMain]上次程序正在运行！跳过本次运行。。。");
            return;
        }
        HistoryConfig.put("hrm.premobile.task.last.time", DateUtil.getDateTime());
        HistoryConfig.put(key, "1");
        HistoryConfig.saveHistory();
        long startTime = System.nanoTime();
        
        System.out.println("[HRMUpdateTaskMain]统计时间段["+DateUtil.getDateTime()+"]");
        
//        String mobile = "18910892562北京";
//        mobile = "+61 0468386992";
//        mobile = "+61（0）467613626";
//        mobile = "＋61426286619";
//        System.out.println(mobile.replaceAll("[^0-9|+]+", ""));
        // 如果有一个参数则修改手机号
        args = new String[]{"1"};
        boolean isUpdateMobile = false;
        if(args != null && args.length == 1){
            
            isUpdateMobile = "1".equals(args[0]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        final String modified = sdf.format(new Date());
        System.out.println("[ODSTaskMain][修改时间]"+modified);
        HRMUpdatePreMobileService service = new HRMUpdatePreMobileService();
        service.start(isUpdateMobile);
        
        HCFetcher.getInstance().shutdown();
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        System.out.println("执行过程总共用时：" + duration + "纳秒");
        System.out.println("执行过程总共用时格式化：" + DateUtil.getDurationTime(duration));
        HistoryConfig.put(key, "0");
        HistoryConfig.saveHistory();
    }

}
