package com.foc.task;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import com.alibaba.fastjson.JSONObject;
import com.foc.TaskSupporter;
import com.foc.TaskTemplate;
import com.foc.conf.GConstants;
import com.foc.conf.HistoryConfig;
import com.foc.fetcher.HCFetcher;
import com.foc.hrm.HRMTask;
import com.foc.hrm.service.HRMService;
import com.foc.util.DateUtil;

public class HRMTaskMain {

    public static void main(String[] args) {
        
        final String key = "hrm.task.is.running";
        if (HistoryConfig.getInt(key, 0) == 1) {
            System.out.println("[HRMTaskMain]上次程序正在运行！跳过本次运行。。。");
            return;
        }
        HistoryConfig.put("hrm.task.last.time", DateUtil.getDateTime());
        HistoryConfig.put(key, "1");
        HistoryConfig.saveHistory();
        long startTime = System.nanoTime();
        
        System.out.println("[HRMTaskMain]统计时间段["+DateUtil.getDateTime()+"]");
        
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        final String modified = sdf.format(new Date());
        System.out.println("[ODSTaskMain][修改时间]"+modified);
        // TODO Auto-generated method stub
        final ExecutorService threadPool = Executors.newCachedThreadPool();

        threadPool.execute(new Runnable() {// 5.4 HRM人资接口

            @Override
            public void run() {
                
                 startHRMTask(threadPool, modified);// HRM 插入或更新user和role的数据
            }
        });
        threadPool.shutdown();

        while (true) {
            if (threadPool.isTerminated()) {
                System.out.println("线程池结束了！");
                HCFetcher.getInstance().shutdown();
                
                long endTime = System.nanoTime();
                long duration = endTime - startTime;
                System.out.println("执行存储过程总共用时：" + duration + "纳秒");
                System.out.println("执行存储过程总共用时格式化：" + DateUtil.getDurationTime(duration));
                HistoryConfig.put(key, "0");
                HistoryConfig.saveHistory();
                System.exit(0);
                break;
            }
            try {
                Thread.sleep(100);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    private static void startHRMTask(ExecutorService threadPool, final String modified) {

        /**
         * HRM人资接口
         */
        HRMTask hRMTask = new HRMTask(new TaskSupporter() {
            @Override
            public String setBaseUrl(TaskTemplate taskTemplate) {
                return GConstants.FOC_HRM_URL + "&pageParam.pageIndex=" + taskTemplate.getPageIndex()
                        + "&pageParam.pageSize=" + GConstants.PAGE_SIZE;
                // return
                // GConstants.FOC_FLIGHT_DYNAMIC_URL+"&pageParam.pageIndex="+taskTemplate.getPageIndex()+"&pageParam.pageSize="+GConstants.PAGE_SIZE;
            }
            @Override
            public Map<String, String> setParams() {
                Map<String, String> params = new TreeMap<String, String>();
                params.put("companyNodeId", "4477");
                params.put("includePost", "1");// 默认null，即false如果true，则返回的HrEmp才会包含empPosts属性值
                return params;
            }
            @Override
            public void successHandle(JSONObject result) {
                HRMService hRMService = new HRMService();
                hRMService.insertHRM(result, modified);
            }
            @Override
            public String setPageIndexProperty() {
                return "foc.hrm.page.index";
            }
            @Override
            public boolean isGet() {
                return true;
            }
            @Override
            public boolean isPost() {
                return false;
            }
            
            @Override
            public String getApiName() {
                
                return "hrm";
            }
            @Override
            public boolean finish() {
                // TODO Auto-generated method stub
                return false;
            }
        });
        hRMTask.run();
        // threadPool.execute(hRMTask);
    }
}
