package com.foc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Map.Entry;
import java.util.TreeMap;

import javax.print.attribute.standard.Finishings;

import org.apache.commons.io.IOUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.foc.conf.GConstants;
import com.foc.conf.HistoryConfig;
import com.foc.fetcher.FetchEntity;
import com.foc.fetcher.HCFetcher;
import com.foc.util.DateUtil;
/**
 * 任务模板，具体结果处理请参考successHandle
 * @author panjianlin
 *
 */
public abstract class TaskTemplate{

    protected String pageIndexProperty;

    protected int pageIndex;

    protected String baseUrl;
    
    protected boolean isFinish=false;

//    private HCFetcher fetcher;

    protected Map<String,String> params = new TreeMap<String,String>();

    protected TaskSupporter taskSupporter;

    public TaskTemplate(TaskSupporter taskSupporter){
        this.taskSupporter = taskSupporter;
        this.baseUrl = this.taskSupporter.setBaseUrl(this);
        this.params = this.taskSupporter.setParams();
    }

    public void run(){
        init();
        mainTask();
//        destroy();

    }

    private void init() {
        
        initIndexProperty();
    }

    private void initIndexProperty() {
        this.pageIndexProperty = taskSupporter.setPageIndexProperty();
    }

    public int getHistoryConfigPageIndex() {
        int i = HistoryConfig.getIntValue(getPageIndexProperty(), 1);
        return i;
    }

    public void setHistoryConfigPageIndex() {
        HistoryConfig.put(getPageIndexProperty(), ""+this.pageIndex);// 记录最后成功的索引地址
        HistoryConfig.saveHistory();
    }

    public String getPageIndexProperty(){
        return this.pageIndexProperty;
    }


    private void mainTask() {

        initPageIndex();
        while (isFinish == false) {
            //请求接口获取结果
            FetchEntity entity = getEntity();

            if(entity.isSuccess()){

                String text = entity.getContent("utf-8");
                
                JSONObject result = JSON.parseObject(text);
                if(result.containsKey("result")){// 处理首航接口
                    String resultCode = result.getJSONObject("result").getString("resultCode");
                    System.out.println("接口返回状态码【"+resultCode+"】");
                    if("1000".equals(resultCode)){ //

                        if(GConstants.getBoolean("is.save.history", false)){
                            try {
                                
                                String dayPath = DateUtil.dateToStr(new Date(), "yyyyMMdd");
                                File file = new File(GConstants.BASE_PATH+GConstants.FS+dayPath);
                                if(file.exists() == false){
                                    
                                    file.mkdirs();
                                }
                                String dateFrom = DateUtil.dateToStr(new Date(), "yyyyMMddHHmmss");
                                String apiName = taskSupporter.getApiName();
                                String fileName = apiName+"."+dateFrom+".page."+getPageIndex()+".json";
                                
                                IOUtils.write(text, new FileOutputStream(new File(GConstants.BASE_PATH+GConstants.FS+dayPath+GConstants.FS+fileName)));
//                                System.exit(0);
                            } catch (IOException e1) {
                                // TODO Auto-generated catch block
                                e1.printStackTrace();
                            }
                        }
                        JSONObject data = (JSONObject)result.getJSONObject("data");
                        if(data == null || data.isEmpty()){
                            System.out.println("获取数据为空  结束");
                            System.out.println("返回数据: "+data);
                            break;
                        }
                        if(data.containsKey("apiResp")){
                            JSONArray apiResp = data.getJSONArray("apiResp");
                            if(apiResp == null || apiResp.size() == 0){
                                System.out.println("获取数据为空  结束");
                                break;
                            }
                            if(apiResp.size()<GConstants.PAGE_SIZE){
                                isFinish = true;
                            }
                            System.out.println("本次处理数据量："+apiResp.size());
                        } else if(data.containsKey("fltLegsChanges")){
                            JSONArray apiResp = data.getJSONArray("fltLegsChanges");
                            if(apiResp == null || apiResp.size() == 0){
                                System.out.println("获取数据为空  结束");
                                break;
                            }
                            if(apiResp.size()<GConstants.PAGE_SIZE){
                                isFinish = true;
                            }
                            System.out.println("本次处理数据量："+apiResp.size());
                        } else if(data.containsKey("result")){// 飞行任务书
                            JSONArray apiResp = data.getJSONArray("result");
                            if(apiResp == null || apiResp.size() == 0){
                                System.out.println("获取数据为空  结束");
                                break;
                            }
                            if(apiResp.size()<GConstants.PAGE_SIZE){
                                isFinish = true;
                            }
                            System.out.println("本次处理数据量："+apiResp.size());
                        }
                        taskSupporter.successHandle(result);
//                        System.out.println("成功: "+url+"&pageParam.pageIndex="+pageIndex+"&pageParam.pageSize="+GConstants.PAGE_SIZE);

                        pageIndex++;
                        setHistoryConfigPageIndex();// 记录最后成功的索引地址

                    } else if("10005".equals(resultCode)){// 其它状态结束请求
                        failHandle(result);
                        try {
                            System.out.println("延时【"+GConstants.POLITENESS_DELAY/60+"】分钟再次请求【"+DateUtil.dateToStr(new Date(), DateUtil.TIMEF_FORMAT)+"】");
                            Thread.sleep(GConstants.POLITENESS_DELAY*1000);
                        } catch (Exception e) {}
                    } else{
                        System.out.println("状态码为【" + resultCode + "】结束");
                        break ;
                    }
                } else if(result.containsKey("data")){// 处理安科接口
                    String status = result.getString("status");
                    if("2000".equals(status)){
                        if(GConstants.getBoolean("is.save.history", false)){
                            try {
                                
                                String dayPath = DateUtil.dateToStr(new Date(), "yyyyMMdd");
                                File file = new File(GConstants.BASE_PATH+GConstants.FS+dayPath);
                                if(file.exists() == false){
                                    
                                    file.mkdirs();
                                }
                                String dateFrom = DateUtil.dateToStr(new Date(), "yyyyMMddHHmmss");
                                String apiName = taskSupporter.getApiName();
                                String fileName = apiName+"."+dateFrom+".page."+getPageIndex()+".json";
                                
                                IOUtils.write(text, new FileOutputStream(new File(GConstants.BASE_PATH+GConstants.FS+dayPath+GConstants.FS+fileName)));
//                                System.exit(0);
                            } catch (IOException e1) {
                                // TODO Auto-generated catch block
                                e1.printStackTrace();
                            }
                        }
                        JSONObject data = (JSONObject)result.getJSONObject("data");
                        if(data == null || data.isEmpty()){
                            System.out.println("获取数据为空  结束");
                            System.out.println("返回数据: "+data);
                            break;
                        }
                        if(data.containsKey("list")){
                            JSONArray list = data.getJSONArray("list");
                            if(list == null || list.size() == 0){
                                System.out.println("获取数据为空  结束");
                                break;
                            }
                            if(list.size()<GConstants.PAGE_SIZE){
                                isFinish = true;
                            }
                            System.out.println("本次处理数据量："+list.size());
                        }
                        taskSupporter.successHandle(result);
                        pageIndex++;
                        setHistoryConfigPageIndex();// 记录最后成功的索引地址
                    }
                }
            } else {
                System.out.println("获取接口失败   结束");
                break ;
            }
        }
        taskSupporter.finish();
    }

    private void initPageIndex() {
        this.pageIndex = 1;//getHistoryConfigPageIndex();

    }

    private void failHandle(JSONObject result) {
        // TODO Auto-generated method stub

    }

//    public abstract void successHandle(JSONObject result);

    private FetchEntity getEntity() {
//        System.out.println(url+"&pageParam.pageIndex="+pageIndex+"&pageParam.pageSize="+GConstants.PAGE_SIZE);

        if(isGet())
            return get();
        else if(isPost())
            return post();
        else{
            throw new IllegalStateException("期望的是get或post方法");
        }
    }

    private FetchEntity post() {
        //return fetcher.post(url+"&pageParam.pageIndex="+pageIndex+"&pageParam.pageSize="+GConstants.PAGE_SIZE,null);
        //暂时未实现
        try {
            String url = this.urlHandle();
            String params = "";
            if(url.contains("?")){
                
                params = url.substring(url.indexOf("?")+1, url.length());
                url = url.substring(0, url.indexOf("?"));
            }
            System.out.println("METHOD: POST");
            System.out.println("URL: "+url);
            System.out.println("PARAMS: "+params);
            return HCFetcher.getInstance().post(url, params.getBytes("utf-8"));//(url);
        } catch (Exception e) {
            // TODO: handle exception
        }
        FetchEntity entity = new FetchEntity();
        entity.setSuccess(false);
        return entity;
    }

    private FetchEntity get() {

        final String url = this.urlHandle().replaceAll(" ", "%20");
        
//        url = url.replaceAll(" ", "%20");
        System.out.println("METHOD: GET");
        System.out.println("URL: "+url);
        return HCFetcher.getInstance().get(url);
    }

    private synchronized String urlHandle() {
        //设置url
        this.resetBaseUrl();
        //设置参数
        this.resetParams();
        //拼接url和参数
        return this.combineUrlParams();
    }

    public void resetBaseUrl(){
        this.baseUrl = this.taskSupporter.setBaseUrl(this);
    }

    public void resetParams() {
        this.params = this.taskSupporter.setParams();
    }

    private String combineUrlParams() {
        for(Entry<String,String> param : params.entrySet()){

            this.baseUrl += "&" + param.getKey() + "=" + param.getValue();
        }
        return this.baseUrl;
    }

//    public abstract void setParams();

    public boolean isGet(){
        return this.taskSupporter.isGet();
    }

    public boolean isPost(){
        return this.taskSupporter.isPost();
    }


    public int getPageIndex() {
        return pageIndex;
    }

    public boolean isFinish() {
        return isFinish;
    }

    public void setFinish(boolean isFinish) {
        this.isFinish = isFinish;
    }
}
