/**
 *
 */
package com.uc.demo;

import org.apache.commons.lang3.StringUtils;

import com.huawei.esdk.uc.professional.local.bean.RestResponse;
import com.huawei.esdk.uc.professional.local.bean.south.Account;
import com.huawei.esdk.uc.professional.local.bean.south.AddAccountRequest;
import com.huawei.esdk.uc.professional.local.factory.ServiceFactoryEx;
import com.huawei.esdk.uc.professional.local.service.UserProfileServiceEx;

/**
 * 
 * @team BBDTEK IT Team
 * @author renmb
 * @version 1.0
 * @time  2016年12月2日
 */
public class AddAccountDemoMain {

    /**
     * 
     * @author renmb
     * @time  2016年12月2日
     * @param args
     */
    public static void main(String[] args) {
        // TODO Auto-generated method stub
        try {
//            args = new String[]{"21", "12", "12"};
            String userId    = args[0];
            String username  = args[2];
            String departmentId  = args[3];
            int    maxSipNum = Integer.parseInt(args[1]);
            
            
            // 第一步  添加一个账号
            AddAccountRequest accountInfo = new AddAccountRequest();
            accountInfo.setUserId(userId);
            accountInfo.setAccount(new Account());
            accountInfo.getAccount().setAccountType("2");
            accountInfo.getAccount().setLoginName(userId);
            accountInfo.getAccount().setPassword(userId.length() > 1 ? userId.substring(0,2) + "@foc2016" : String.format("%02d", userId) + "@foc2016");
//            accountInfo.getAccount().setPassword(userId.substring(0,2) + "@foc2016");
            accountInfo.getAccount().setName(username);
            accountInfo.getAccount().setRoleId("1");
            accountInfo.getAccount().setUserLevel("1");
            accountInfo.getAccount().setUserState("0");
            accountInfo.getAccount().setDepartmentId(departmentId);
            accountInfo.getAccount().setSex("0");
            accountInfo.getAccount().setCellPhone("");
            accountInfo.getAccount().setWebsite(username);
            accountInfo.getAccount().setOfficePhone("");
            accountInfo.getAccount().setFax("");
            accountInfo.getAccount().setAddr("");
            accountInfo.getAccount().setTitle("");
            
            String accountId = "";
            UserProfileServiceEx userProfileServiceEx = ServiceFactoryEx.getService(UserProfileServiceEx.class);
            //调用userProfileServiceEx服务中的addAccount方法，返回错误码
            RestResponse<String> res = userProfileServiceEx.addAccount(accountInfo);
            
            System.out.println("添加账号返回接口"+res);
            System.out.println("添加账号返回接口"+(res != null && "0".equals(res.getResultCode())));
            if (res != null && "0".equals(res.getResultCode())) {
                //增加成功
                accountId = res.getResult();
                if(StringUtils.isNotEmpty(accountId)){// 第二步 绑定账号
                    accountInfo = new AddAccountRequest();
                    accountInfo.setUserId("123");
                    accountInfo.setAccount(new Account());
                    accountInfo.getAccount().setAccountId(accountId);
//                    accountInfo.getAccount().setName(username);
                    accountInfo.getAccount().setBindNum(String.valueOf(maxSipNum));
                    
                    Integer rest = userProfileServiceEx.numberBind(accountInfo);
                    System.out.println("绑定SIP返回接口"+rest);
                    System.out.println("绑定SIP返回接口"+(rest != null && rest == 0));
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
            System.out.println("请输入三个参数：用户ID 用户名称 SIP号");
        }
    }

}
