package com.foc.sound.entity;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * 聊天记录实体
 * @author lyw
 *
 */
public class SoundRecordingEntity {

    private String id;// 主键
    private String callNo;// 主叫号码
    private String acceptNo;// 被叫号码
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date   beginTime;// 通话开始时间
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date   endTime;// 通话结束时间
    private String result;// 0 通话成功 其它通话失败，未接通为通话失败
    private int    duration;// 通话时长，单位（请安科备注）
    private String downloadUrl;// 录音文件下载地址
    private Long   downloadSize=0L;// 录音文件大小（byte）
    private String callType;
    private String recordId;
	private String callRecordId;
	
	private Date   current;// 接口请求时候的系统时间（yyyy-MM-dd HH:mm:ss），即录音服务器的系统时间
    private Long   currentTimeMillis;// 接口请求时候的系统时间（毫秒），即录音服务器的系统时间
    private String channelType="API";// 来源 API 接口时时同步 CRON 定时任务
    private Date focBeginTime;// FOC系统通话开始时间
    private Date focEndTime;// FOC系统通话结束时间
    private Long focTimeMillis;// FOC系统时间（毫秒），即录音服务器的系统时间
    private int focDiffMillis;// FOC系统和安科间的时间差，focDiffMillis = currentTimeMillis-focCurrentTimeMillis
    private Date createDate;// FOC系统记录时间
    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    public String getCallNo() {
        return callNo;
    }
    public void setCallNo(String callNo) {
        this.callNo = callNo;
    }
    public String getAcceptNo() {
        return acceptNo;
    }
    public void setAcceptNo(String acceptNo) {
        this.acceptNo = acceptNo;
    }
    public Date getBeginTime() {
        return beginTime;
    }
    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }
    public Date getEndTime() {
        return endTime;
    }
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    public String getResult() {
        return result;
    }
    public void setResult(String result) {
        this.result = result;
    }
    public int getDuration() {
        return duration;
    }
    public void setDuration(int duration) {
        this.duration = duration;
    }
    public String getDownloadUrl() {
        return downloadUrl;
    }
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }
    public Long getDownloadSize() {
        return downloadSize;
    }
    public void setDownloadSize(Long downloadSize) {
        this.downloadSize = downloadSize;
    }
    public String getCallRecordId() {
        return callRecordId;
    }
    public void setCallRecordId(String callRecordId) {
        this.callRecordId = callRecordId;
    }
    public Date getCurrent() {
        return current;
    }
    public void setCurrent(Date current) {
        this.current = current;
    }
    public Long getCurrentTimeMillis() {
        return currentTimeMillis;
    }
    public void setCurrentTimeMillis(Long currentTimeMillis) {
        this.currentTimeMillis = currentTimeMillis;
    }
    public String getChannelType() {
        return channelType;
    }
    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }
    public Date getFocBeginTime() {
        return focBeginTime;
    }
    public void setFocBeginTime(Date focBeginTime) {
        this.focBeginTime = focBeginTime;
    }
    public Date getFocEndTime() {
        return focEndTime;
    }
    public void setFocEndTime(Date focEndTime) {
        this.focEndTime = focEndTime;
    }
    public Long getFocTimeMillis() {
        return focTimeMillis;
    }
    public void setFocTimeMillis(Long focTimeMillis) {
        this.focTimeMillis = focTimeMillis;
    }
    public int getFocDiffMillis() {
        return focDiffMillis;
    }
    public void setFocDiffMillis(int focDiffMillis) {
        this.focDiffMillis = focDiffMillis;
    }
    public Date getCreateDate() {
        return createDate;
    }
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    public String getCallType() {
        return callType;
    }
    public void setCallType(String callType) {
        this.callType = callType;
    }
    public String getRecordId() {
        return recordId;
    }
    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }
    
}
