/**
 * 
 */
package com.foc.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;



/**
 * 
 * @team IT Team
 * @author zhanglg
 * @version 1.0
 * @time  2017年4月5日
 */

public class PathFormatUtils {
    private static final String TIME = "time";
    private static final String FULL_YEAR = "yyyy";
    private static final String YEAR = "yy";
    private static final String MONTH = "mm";
    private static final String DAY = "dd";
    private static final String HOUR = "hh";
    private static final String MINUTE = "ii";
    private static final String SECOND = "ss";
    private static final String RAND = "rand";
    
    private static Date currentDate = null;
    
    public static String parse ( String input ) {
        
        Pattern pattern = Pattern.compile( "\\{([^\\}]+)\\}", Pattern.CASE_INSENSITIVE  );
        Matcher matcher = pattern.matcher(input);
        
        PathFormatUtils.currentDate = new Date();
        
        StringBuffer sb = new StringBuffer();
        
        while ( matcher.find() ) {
            
            matcher.appendReplacement(sb, PathFormatUtils.getString( matcher.group( 1 ) ) );
            
        }
        
        matcher.appendTail(sb);
        
        return sb.toString();
    }
    
    /**
     * 格式化路径, 把windows路径替换成标准路径
     * @param input 待格式化的路径
     * @return 格式化后的路径
     */
    public static String format ( String input ) {
        
        return input.replace( "\\", "/" );
        
    }

    public static String parse ( String input, String filename ) {
    
        Pattern pattern = Pattern.compile( "\\{([^\\}]+)\\}", Pattern.CASE_INSENSITIVE  );
        Matcher matcher = pattern.matcher(input);
        String matchStr = null;
        
        PathFormatUtils.currentDate = new Date();
        
        StringBuffer sb = new StringBuffer();
        
        while ( matcher.find() ) {
            
            matchStr = matcher.group( 1 );
            if ( matchStr.indexOf( "filename" ) != -1 ) {
                filename = filename.replace( "$", "\\$" ).replaceAll( "[\\/:*?\"<>|]", "" );
                matcher.appendReplacement(sb, filename );
            } else {
                matcher.appendReplacement(sb, PathFormatUtils.getString( matchStr ) );
            }
            
        }
        
        matcher.appendTail(sb);
        
        return sb.toString();
    }
        
    private static String getString ( String pattern ) {
        
        pattern = pattern.toLowerCase();
        
        // time 处理
        if ( pattern.indexOf( PathFormatUtils.TIME ) != -1 ) {
            return PathFormatUtils.getTimestamp();
        } else if ( pattern.indexOf( PathFormatUtils.FULL_YEAR ) != -1 ) {
            return PathFormatUtils.getFullYear();
        } else if ( pattern.indexOf( PathFormatUtils.YEAR ) != -1 ) {
            return PathFormatUtils.getYear();
        } else if ( pattern.indexOf( PathFormatUtils.MONTH ) != -1 ) {
            return PathFormatUtils.getMonth();
        } else if ( pattern.indexOf( PathFormatUtils.DAY ) != -1 ) {
            return PathFormatUtils.getDay();
        } else if ( pattern.indexOf( PathFormatUtils.HOUR ) != -1 ) {
            return PathFormatUtils.getHour();
        } else if ( pattern.indexOf( PathFormatUtils.MINUTE ) != -1 ) {
            return PathFormatUtils.getMinute();
        } else if ( pattern.indexOf( PathFormatUtils.SECOND ) != -1 ) {
            return PathFormatUtils.getSecond();
        } else if ( pattern.indexOf( PathFormatUtils.RAND ) != -1 ) {
            return PathFormatUtils.getRandom( pattern );
        }
        
        return pattern;
        
    }

    private static String getTimestamp () {
        return System.currentTimeMillis() + "";
    }
    
    private static String getFullYear () {
        return new SimpleDateFormat( "yyyy" ).format( PathFormatUtils.currentDate );
    }
    
    private static String getYear () {
        return new SimpleDateFormat( "yy" ).format( PathFormatUtils.currentDate );
    }
    
    private static String getMonth () {
        return new SimpleDateFormat( "MM" ).format( PathFormatUtils.currentDate );
    }
    
    private static String getDay () {
        return new SimpleDateFormat( "dd" ).format( PathFormatUtils.currentDate );
    }
    
    private static String getHour () {
        return new SimpleDateFormat( "HH" ).format( PathFormatUtils.currentDate );
    }
    
    private static String getMinute () {
        return new SimpleDateFormat( "mm" ).format( PathFormatUtils.currentDate );
    }
    
    private static String getSecond () {
        return new SimpleDateFormat( "ss" ).format( PathFormatUtils.currentDate );
    }
    
    private static String getRandom ( String pattern ) {
        
        int length = 0;
        pattern = pattern.split( ":" )[ 1 ].trim();
        
        length = Integer.parseInt( pattern );
        
        return ( Math.random() + "" ).replace( ".", "" ).substring( 0, length );
        
    }

    public static void main(String[] args) {
        // TODO Auto-generated method stub

    }
}
