/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.huawei.esdk.uc.professional.local.bean.RestRequestMessage;
import com.huawei.esdk.uc.professional.local.utils.PropertiesUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class RestUtils {
    private static final Logger LOGGER = Logger.getLogger(RestUtils.class);
    private static final RestUtils REST_UTIL = new RestUtils();
    private static final String REST_URL_MAPPING = PropertiesUtils.getValue("rest.url.mapping");
    private static final String REST_URL = PropertiesUtils.getValue("rest.url");
    private Gson GSON = this.getGson();
    private static String scheme = REST_URL.substring(0, REST_URL.indexOf("://"));
    private static String hostname;
    private static int port;
    private static String userName;
    private static String password;
    private DefaultHttpClient httpClient;
    private BasicHttpContext localContext;
    private HttpHost target;
    private int serverNounceCount;

    static {
        port = Integer.parseInt(REST_URL.substring(REST_URL.lastIndexOf(":") + 1));
        hostname = REST_URL.substring(REST_URL.indexOf("://") + 3, REST_URL.lastIndexOf(":"));
        userName = PropertiesUtils.getValue("username");
        password = PropertiesUtils.getValue("password");
    }

    private RestUtils() {
    }

    public static synchronized RestUtils getInstance() {
        return REST_UTIL;
    }

    public String sendMessage(RestRequestMessage message, String resourcePath) throws ClientProtocolException, URISyntaxException, IOException {
        this.adapterScheme();
        this.buildBasicHttpContext();
        HttpRequestBase request = this.buildRequestMessage(message, resourcePath);
        this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.target.getHostName(), this.target.getPort()), (Credentials)new UsernamePasswordCredentials(userName, password));
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(this.target, (HttpRequest)request, (HttpContext)this.localContext);
            if (response != null) {
                if (200 == response.getStatusLine().getStatusCode()) {
                    String responsePayload;
                    HttpEntity entity = response.getEntity();
                    String string = responsePayload = EntityUtils.toString((HttpEntity)entity);
                    return string;
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    return "401";
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error((Object)"httpclient error", (Throwable)e);
            return null;
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    private void adapterScheme() {
        PoolingClientConnectionManager conMgr = new PoolingClientConnectionManager();
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)conMgr);
        this.target = new HttpHost(hostname, port, scheme);
        if ("https".equalsIgnoreCase(scheme)) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLSv1.1");
                X509TrustManager tm = new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }
                };
                ctx.init(null, new TrustManager[]{tm}, null);
                SSLSocketFactory sslSocketFactory = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                SchemeRegistry registry = conMgr.getSchemeRegistry();
                registry.register(new Scheme(scheme, port, (SchemeSocketFactory)sslSocketFactory));
            }
            catch (Exception ex) {
                LOGGER.error((Object)"https error", (Throwable)ex);
            }
        }
    }

    private void buildBasicHttpContext() {
        BasicAuthCache authCache = new BasicAuthCache();
        DigestScheme digestScheme = new DigestScheme();
        digestScheme.overrideParamter("nc", String.valueOf(this.serverNounceCount++));
        digestScheme.overrideParamter("cnonce", UUID.randomUUID().toString().replaceAll("-", ""));
        digestScheme.overrideParamter("qop", "auth");
        authCache.put(this.target, (AuthScheme)digestScheme);
        this.localContext = new BasicHttpContext();
        this.localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
    }

    private HttpRequestBase buildRequestMessage(RestRequestMessage message, String reourecePath) throws URISyntaxException, UnsupportedEncodingException {
        HttpGet request;
        if ("GET".equalsIgnoreCase(message.getHttpMethod())) {
            HttpGet httpGet = new HttpGet(this.getServerURL(reourecePath));
            this.setParameters((HttpRequestBase)httpGet, message.getParameters());
            request = httpGet;
        } else if ("POST".equalsIgnoreCase(message.getHttpMethod())) {
            HttpPost httpPost = new HttpPost(this.getServerURL(reourecePath));
            httpPost.setEntity((HttpEntity)new StringEntity(this.GSON.toJson(message.getPayload()), ContentType.APPLICATION_JSON));
            request = httpPost;
        } else if ("PUT".equalsIgnoreCase(message.getHttpMethod())) {
            HttpPut httpPut = new HttpPut(this.getServerURL(reourecePath));
            httpPut.setEntity((HttpEntity)new StringEntity(this.GSON.toJson(message.getPayload()), ContentType.APPLICATION_JSON));
            request = httpPut;
        } else if ("DELETE".equalsIgnoreCase(message.getHttpMethod())) {
            HttpDelete httpDelete = new HttpDelete(this.getServerURL(reourecePath));
            this.setParameters((HttpRequestBase)httpDelete, message.getParameters());
            request = httpDelete;
        } else {
            String msg = String.valueOf(message.getHttpMethod()) + " is not a valid HTTP method";
            LOGGER.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        return request;
    }

    private void setParameters(HttpRequestBase httpRequest, Map<String, String> parameters) throws URISyntaxException {
        if (!parameters.isEmpty()) {
            URIBuilder uriBuilder = new URIBuilder(httpRequest.getURI());
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
            httpRequest.setURI(uriBuilder.build());
        }
    }

    private String getServerURL(String resourcePath) {
        return String.valueOf(REST_URL_MAPPING) + resourcePath;
    }

    protected Gson getGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date arg0, Type arg1, JsonSerializationContext arg2) {
                return new JsonPrimitive((Number)arg0.getTime());
            }
        });
        return builder.create();
    }
}

