/**
 *
 */
package com.foc.version;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.MapListHandler;

import com.foc.util.DBHelper;

/**
 * 
 * @team BBDTEK IT Team
 * @author renmb
 * @version 1.0
 * @time  2016年12月12日
 */
public class VersionService {
    private QueryRunner run = null;

    public VersionService() {
        try {
            this.run = new QueryRunner(DBHelper.getDataSource());
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    public String getCurrentVersion(String type, String dateValue){
        try {
            
            String query = "SELECT * FROM foc_data_version WHERE date_value=? AND type=?";
            System.out.println(query+"["+dateValue+","+type+"]");
            List<Map<String, Object>> list = null;
            MapListHandler handler = new MapListHandler();
            list = run.query(query, handler, dateValue, type);
            if (list != null && list.size() > 0) {
                return list.get(0).get("version_name").toString();
            }
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return "";
    }
    public boolean updateCurrentVersion(String type, String dateValue, String versionName){
        try {
            
            String query = "UPDATE foc_data_version SET version_name=?,update_date=? WHERE date_value=? AND type=?";
            Date updateDate = new Date();
            System.out.println(query+"["+versionName+","+updateDate+","+dateValue+","+type+"]");
            int count = run.update(query, versionName, updateDate, dateValue, type);
            return count>0;
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return false;
    }
    public boolean addCurrentVersion(String type, String dateValue, String versionName){
        try {
            
            String query = "INSERT INTO `foc_data_version` (`type`, `date_value`, `version_name`, `update_date`) VALUES (?, ?, ?, ?);";
            Date updateDate = new Date();
            System.out.println(query+"["+type+","+dateValue+","+versionName+","+updateDate+"]");
            int count = run.update(query, type, dateValue, versionName, updateDate);
            return count>0;
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return false;
    }
}
