/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.serviceImpl;

import com.huawei.esdk.uc.professional.local.bean.NumberInfo;
import com.huawei.esdk.uc.professional.local.bean.RestResponse;
import com.huawei.esdk.uc.professional.local.bean.south.AddAccountRequest;
import com.huawei.esdk.uc.professional.local.bean.south.AddDepartmentResponse;
import com.huawei.esdk.uc.professional.local.bean.south.AddDepartmentResult;
import com.huawei.esdk.uc.professional.local.bean.south.DepartmentRequest;
import com.huawei.esdk.uc.professional.local.bean.south.PersonInfo;
import com.huawei.esdk.uc.professional.local.bean.south.QueryDepartmentInfoList;
import com.huawei.esdk.uc.professional.local.bean.south.QueryDepartmentResponse;
import com.huawei.esdk.uc.professional.local.bean.south.QueryPersonInfoResponse;
import com.huawei.esdk.uc.professional.local.bean.south.ResHeaderBean;
import com.huawei.esdk.uc.professional.local.bean.south.SipAccount;
import com.huawei.esdk.uc.professional.local.bean.south.SipList;
import com.huawei.esdk.uc.professional.local.bean.south.SipQueryRequest;
import com.huawei.esdk.uc.professional.local.bean.south.SipQueryResponse;
import com.huawei.esdk.uc.professional.local.bean.south.SipRequest;
import com.huawei.esdk.uc.professional.local.resource.AccountResource;
import com.huawei.esdk.uc.professional.local.resource.BindNumResource;
import com.huawei.esdk.uc.professional.local.resource.DepartmentResource;
import com.huawei.esdk.uc.professional.local.resource.SIPAccountResource;
import com.huawei.esdk.uc.professional.local.resource.UserProfileCorpList;
import com.huawei.esdk.uc.professional.local.service.UserProfileServiceEx;
import com.huawei.esdk.uc.professional.local.utils.Encrypt;
import com.huawei.esdk.uc.professional.local.utils.KeyManagerUtils;
import com.huawei.esdk.uc.professional.local.utils.StringUtils;
import org.apache.log4j.Logger;

public class UserProfileServiceExImpl
implements UserProfileServiceEx {
    private UserProfileCorpList userProfileCorpList = new UserProfileCorpList();
    private DepartmentResource departmentResource = new DepartmentResource();
    private AccountResource accountResource = new AccountResource();
    private BindNumResource bindNumResource = new BindNumResource();
    private SIPAccountResource sipAccountResource = new SIPAccountResource();
    private static final Logger LOGGER = Logger.getLogger(UserProfileServiceExImpl.class);
    private static UserProfileServiceExImpl instance = null;

    public static synchronized UserProfileServiceExImpl getInstance() {
        if (instance == null) {
            instance = new UserProfileServiceExImpl();
        }
        return instance;
    }

    @Override
    public RestResponse<QueryDepartmentInfoList> queryDeptListInfo(String userId, String parentId, String pageCount, String pageNum) {
        RestResponse<QueryDepartmentInfoList> result = new RestResponse<QueryDepartmentInfoList>();
        QueryDepartmentResponse response = this.departmentResource.queryDepartment(userId, parentId, pageCount, pageNum);
        result.setResult(response.getQueryDepartmentInfoList());
        result.setResultCode(response.getResultCode());
        result.setResultContext(response.getResultContext());
        return result;
    }

    @Override
    public RestResponse<PersonInfo> queryStaffInfo(String ucAccount) {
        RestResponse<PersonInfo> result = new RestResponse<PersonInfo>();
        QueryPersonInfoResponse response = this.userProfileCorpList.queryPersonInfo(ucAccount);
        result.setResult(response.getPersonInfo());
        result.setResultCode(response.getResultCode());
        result.setResultContext(response.getResultContext());
        return result;
    }

    @Override
    public RestResponse<AddDepartmentResult> addDept(DepartmentRequest departmentInfo) {
        RestResponse<AddDepartmentResult> result = new RestResponse<AddDepartmentResult>();
        AddDepartmentResponse response = this.departmentResource.addDepartment(departmentInfo);
        result.setResultCode(response.getResultCode());
        result.setResultContext(response.getResultContext());
        if ("0".equals(response.getResultCode())) {
            result.setResult(new AddDepartmentResult());
            result.getResult().setDepartmentId(response.getDepartmentId());
            result.getResult().setDepartmentNo(response.getDepartmentNo());
        }
        return result;
    }

    @Override
    public Integer modifyDept(DepartmentRequest departmentInfo) {
        return Integer.parseInt(this.departmentResource.modifyDepartment(departmentInfo).getResultCode());
    }

    @Override
    public Integer delDept(String userId, String departmentId) {
        return Integer.parseInt(this.departmentResource.deleteDepartment(userId, departmentId).getResultCode());
    }

    @Override
    public RestResponse<String> addAccount(AddAccountRequest accountInfo) {
        int resp = KeyManagerUtils.initTransmissionMode();
        if (resp != 0) {
            RestResponse<String> res = new RestResponse<String>();
            res.setResult(String.valueOf(resp));
            return res;
        }
        try {
            accountInfo.getAccount().setOldPassword(Encrypt.getEncryptPwd(accountInfo.getAccount().getOldPassword()));
            accountInfo.getAccount().setNewPassword(Encrypt.getEncryptPwd(accountInfo.getAccount().getNewPassword()));
            accountInfo.getAccount().setPassword(Encrypt.getEncryptPwd(accountInfo.getAccount().getPassword()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Encrypt Error:" + e));
            RestResponse<String> res = new RestResponse<String>();
            res.setResult(String.valueOf(2130000031));
            return res;
        }
        RestResponse<String> response = this.accountResource.addAccount(accountInfo);
        return response;
    }

    @Override
    public Integer addNumber(SipRequest numberInfo) {
        int resp = KeyManagerUtils.initTransmissionMode();
        if (resp != 0) {
            return resp;
        }
        try {
            if (numberInfo.getSip() != null && numberInfo.getSip().getSipAuth() != null) {
                numberInfo.getSip().getSipAuth().setPassword(Encrypt.getEncryptPwd(numberInfo.getSip().getSipAuth().getPassword()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Encrypt Error:" + e));
            return 2130000031;
        }
        return Integer.parseInt(this.sipAccountResource.addSIP(numberInfo).getResultCode());
    }

    @Override
    public Integer modifyNumber(SipRequest numberInfo) {
        int resp = KeyManagerUtils.initTransmissionMode();
        if (resp != 0) {
            return resp;
        }
        try {
            if (numberInfo.getSip() != null && numberInfo.getSip().getSipAuth() != null) {
                numberInfo.getSip().getSipAuth().setPassword(Encrypt.getEncryptPwd(numberInfo.getSip().getSipAuth().getPassword()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Encrypt Error:" + e));
            return 2130000031;
        }
        return Integer.parseInt(this.sipAccountResource.modifySIP(numberInfo).getResultCode());
    }

    @Override
    public Integer delNumber(SipRequest numberInfo) {
        return Integer.parseInt(this.sipAccountResource.deleteSip(numberInfo).getResultCode());
    }

    @Override
    public RestResponse<SipList> queryNumber(SipQueryRequest req) {
        RestResponse<SipList> result = new RestResponse<SipList>();
        int resp = KeyManagerUtils.initTransmissionMode();
        if (resp != 0) {
            result.setResultCode(String.valueOf(resp));
            return result;
        }
        SipQueryResponse response = this.sipAccountResource.querySip(req);
        result.setResultCode(response.getResultCode());
        if (response.getSipList() != null && response.getSipList().getSips() != null) {
            try {
                for (SipAccount sip : response.getSipList().getSips()) {
                    if (sip.getSipAuth() == null) continue;
                    sip.getSipAuth().setPassword(Encrypt.getDecryptPwd(sip.getSipAuth().getPassword()));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Encrypt Error:" + e));
                result.setResultCode(String.valueOf(2130000031));
                return result;
            }
        }
        result.setResult(response.getSipList());
        result.setResultContext(response.getResultContext());
        return result;
    }

    @Override
    public Integer numberBind(AddAccountRequest acct) {
        return Integer.parseInt(this.bindNumResource.bindNum(acct).getResultCode());
    }

    protected int checkNumberInfo(NumberInfo numberInfo) {
        if (numberInfo.getCorpInterNumber() == null || numberInfo.getTerminalType() == null) {
            return 19100003;
        }
        if (!StringUtils.isNumber(numberInfo.getCorpInterNumber())) {
            return 19100004;
        }
        if (numberInfo.getPublicNumber() != null && !StringUtils.isNumber(numberInfo.getPublicNumber())) {
            return 19100004;
        }
        if (numberInfo.getTerminalType() == 0 || numberInfo.getTerminalType() == 1) {
            return 0;
        }
        return 19100004;
    }

    @Override
    public Integer modifyAcountPassword(AddAccountRequest acct) {
        int resp = KeyManagerUtils.initTransmissionMode();
        if (resp != 0) {
            return resp;
        }
        try {
            acct.getAccount().setOldPassword(Encrypt.getEncryptPwd(acct.getAccount().getOldPassword()));
            acct.getAccount().setNewPassword(Encrypt.getEncryptPwd(acct.getAccount().getNewPassword()));
            acct.getAccount().setPassword(Encrypt.getEncryptPwd(acct.getAccount().getPassword()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Encrypt Error:" + e));
            return 2130000031;
        }
        ResHeaderBean response = this.accountResource.modifyAcountPassword(acct);
        return Integer.parseInt(response.getResultCode());
    }
}

