/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.convert;

import com.huawei.esdk.uc.professional.local.bean.ContactNumberBase;
import com.huawei.esdk.uc.professional.local.bean.DepartmentInfo;
import com.huawei.esdk.uc.professional.local.bean.DeptInfoBase;
import com.huawei.esdk.uc.professional.local.bean.PageInfo;
import com.huawei.esdk.uc.professional.local.bean.QueryMode;
import com.huawei.esdk.uc.professional.local.bean.QueryResultList;
import com.huawei.esdk.uc.professional.local.bean.StaffInfo;
import com.huawei.esdk.uc.professional.local.bean.UCSDKResponse;
import com.huawei.esdk.uc.professional.local.bean.south.QueryEnterpriseRequest;
import com.huawei.esdk.uc.professional.local.bean.south.QueryEnterpriseResponse;
import com.huawei.esdk.uc.professional.local.bean.south.QueryPersonInfoResponse;
import com.huawei.esdk.uc.professional.local.exception.ECException;
import java.util.ArrayList;

public class UserProfileCorpListConvert {
    public QueryEnterpriseRequest getQueryEnterpriseRequest(String departmentId, String pageNum, String pageCount) {
        QueryEnterpriseRequest queryEnterpriseRequest = new QueryEnterpriseRequest();
        queryEnterpriseRequest.setDepartmentId(departmentId);
        queryEnterpriseRequest.setPageNum(pageNum);
        queryEnterpriseRequest.setPageCount(pageCount);
        return queryEnterpriseRequest;
    }

    public QueryEnterpriseRequest queryDeptListInfoNative2Rest(String deptId, QueryMode queryMode) throws ECException {
        if (deptId == null || queryMode.getMode() == null || queryMode.getOffset() == null || queryMode.getPageNum() == null || queryMode.getPageSize() == null) {
            throw new ECException(0x22009002, "\u5fc5\u586b\u53c2\u6570\u672a\u586b");
        }
        QueryEnterpriseRequest request = new QueryEnterpriseRequest();
        request.setDepartmentId(deptId);
        request.setPageCount(String.valueOf(queryMode.getPageSize()));
        request.setPageNum(String.valueOf(queryMode.getPageNum()));
        return request;
    }

    public UCSDKResponse<QueryResultList<DeptInfoBase>> queryDeptListInfoRest2Native(QueryEnterpriseResponse response) {
        if (response == null) {
            return null;
        }
        UCSDKResponse<QueryResultList<DeptInfoBase>> result = new UCSDKResponse<QueryResultList<DeptInfoBase>>();
        result.setResultCode(Integer.parseInt(response.getResultCode()));
        QueryResultList queryResultList = new QueryResultList();
        if (response.getEnterpriseList() != null && response.getEnterpriseList().getDepartments() != null && response.getEnterpriseList().getDepartments().size() > 0) {
            PageInfo pageInfo = new PageInfo();
            pageInfo.setPageSize(Integer.parseInt(response.getEnterpriseList().getDeptSum()));
            queryResultList.setPageInfo(pageInfo);
            ArrayList<DeptInfoBase> resultInfos = new ArrayList<DeptInfoBase>();
            for (DepartmentInfo departmentInfo : response.getEnterpriseList().getDepartments()) {
                DeptInfoBase deptInfoBase = new DeptInfoBase();
                deptInfoBase.setParentDeptId(response.getEnterpriseList().getDeptId());
                deptInfoBase.setDeptId(departmentInfo.getDeptId());
                deptInfoBase.setDeptName(departmentInfo.getDeptName());
                resultInfos.add(deptInfoBase);
            }
            queryResultList.setResultInfos(resultInfos);
        }
        result.setResult(queryResultList);
        return result;
    }

    public UCSDKResponse<StaffInfo> queryStaffInfoRest2Native(QueryPersonInfoResponse response) {
        if (response == null) {
            return null;
        }
        UCSDKResponse<StaffInfo> result = new UCSDKResponse<StaffInfo>();
        result.setResultCode(Integer.parseInt(response.getResultCode()));
        if (response.getPersonInfo() != null) {
            StaffInfo staffInfo = new StaffInfo();
            staffInfo.setStaffId(response.getPersonInfo().getStaffId());
            staffInfo.setUcNumber(response.getPersonInfo().getStaffAccount());
            staffInfo.setStaffNumber(response.getPersonInfo().getStaffNO());
            staffInfo.setStaffName(response.getPersonInfo().getName());
            staffInfo.setZipcode(response.getPersonInfo().getZip());
            staffInfo.setAddress(response.getPersonInfo().getAddr());
            staffInfo.setSex(response.getPersonInfo().getSex());
            staffInfo.setDeptName(response.getPersonInfo().getCredit());
            staffInfo.setEmail(response.getPersonInfo().getEmail());
            staffInfo.setHomePhone(response.getPersonInfo().getHomePhone());
            ArrayList<ContactNumberBase> mobilePhone = new ArrayList<ContactNumberBase>();
            ContactNumberBase mobileContactNumberBase = new ContactNumberBase();
            mobileContactNumberBase.setNumber(response.getPersonInfo().getMobile());
            mobilePhone.add(mobileContactNumberBase);
            staffInfo.setMobilePhone(mobilePhone);
            staffInfo.setContactDesc(response.getPersonInfo().getUnderwrite());
            ArrayList<ContactNumberBase> officePhone = new ArrayList<ContactNumberBase>();
            ContactNumberBase officeContactNumberBase = new ContactNumberBase();
            officeContactNumberBase.setNumber(response.getPersonInfo().getOfficePhone());
            officePhone.add(officeContactNumberBase);
            staffInfo.setOfficePhone(officePhone);
            ArrayList<ContactNumberBase> otherPhone = new ArrayList<ContactNumberBase>();
            ContactNumberBase otherContactNumberBase = new ContactNumberBase();
            otherContactNumberBase.setNumber(response.getPersonInfo().getOtherPhone());
            otherPhone.add(otherContactNumberBase);
            staffInfo.setOtherPhone(otherPhone);
            ArrayList<ContactNumberBase> fax = new ArrayList<ContactNumberBase>();
            ContactNumberBase faxContactNumberBase = new ContactNumberBase();
            faxContactNumberBase.setNumber(response.getPersonInfo().getFax());
            fax.add(faxContactNumberBase);
            staffInfo.setFax(fax);
            ArrayList<String> voip = new ArrayList<String>();
            voip.add(response.getPersonInfo().getVoip());
            staffInfo.setVoip(voip);
            result.setResult(staffInfo);
        }
        return result;
    }
}

