import axios from "axios";
import { Message } from "element-ui";
import { getToken } from "@/utils/auth";

const config = {
  // proxy: "https://exam.smart-zj.cn:9100/exam/", // 新线上地址
  // proxy: "http://81.69.231.72:8881/", // 测试地址
  proxy: "http://192.168.3.87:8881/", //本地
};

//axios基本配置
const api = axios.create({
  withCredentials: false,
});
// 请求拦截，配置一些公共的参数
api.interceptors.request.use(
  (conf) => {
    //请求带token
    // conf.headers['Authorization'] = store2('accesstoken')
    let appId = /*getToken()*/ "1234";
    if (conf.data) conf.data.appId = appId;
    return conf;
  },
  (error) => ({
    status: 0,
    msg: error.message,
  })
);

// 响应拦截
api.interceptors.response.use(
  (response) => {
    console.log("响应返回--", response);
    // console.log(response);
    const res = response.data;
    if (parseInt(res.code) === 200) {
      return Promise.resolve(response).then(checkCode);
    } else {
      Message.error(res.message || "网络错误");
      return Promise.resolve(response).then(checkCode);
    }
  },
  (error) => {
    return Promise.resolve(error).then(checkStatus);
  }
);

// App应用管理 第二版 appId!=1234
//axios基本配置
const api1 = axios.create({
  withCredentials: false,
});
// 请求拦截，配置一些公共的参数
api1.interceptors.request.use(
  (conf) => {
    //请求带token
    // conf.headers['Authorization'] = store2('accesstoken')
    let appId = /*getToken()*/ "1234";
    if (conf.data) conf.data.appId = appId;
    return conf;
  },
  (error) => ({
    status: 0,
    msg: error.message,
  })
);

// 响应拦截
api1.interceptors.response.use(
  (response) => {
    console.log("响应返回--", response);
    // console.log(response);
    const res = response.data;
    if (parseInt(res.code) === 200) {
      return Promise.resolve(response).then(checkCode);
    }
    if (parseInt(res.code) === 1002) {
      return Promise.resolve(response).then(checkCode);
    } else {
      Message.error(res.message || "网络错误");
      return Promise.resolve(response).then(checkCode);
    }
  },
  (error) => {
    return Promise.resolve(error).then(checkStatus);
  }
);

//http状态码错误处理
const checkStatus = () => {
  const returnData = {
    code: "500",
    msg: "服务器存在异常",
  };
  return returnData;
};

const checkCode = (res) => {
  if (res) {
    if (parseInt(res.data.code) === 200) {
      const returnData = {
        success: true,
        data: res.data.data,
        msg: res.data.message,
      };
      return returnData;
    } else {
      //统一处理错误
      const returnData = {
        success: false,
        data: res.data.data,
        msg: res.data.message,
      };
      return returnData;
    }
  } else {
    const returnData = {
      success: false,
      msg: res.data.message,
    };
    return returnData;
  }
};

// 解析参数
const formatParams = (method = "GET", params, config) => {
  //headers配置
  const headers = config
    ? config
    : {
        "Content-Type": "application/json;charset=utf-8",
      };
  switch (method) {
    case "POST":
      return {
        headers,
        method,
        data: params,
      };
    case "PUT":
      return {
        headers,
        method,
        data: params,
      };
    case "DELETE":
      return {
        headers,
        method,
        data: params,
      };
    case "GET":
      return {
        headers,
        method,
      };
    default:
      return {
        headers,
        method,
        params,
      };
  }
};

const formatParams1 = (method = "GET", params, config) => {
  //headers配置
  const headers = config
    ? config
    : {
        "Content-Type": "application/json;charset=utf-8",
      };
  switch (method) {
    case "POST":
      return {
        headers,
        method,
        data: params,
      };
    case "PUT":
      return {
        headers,
        method,
        data: params,
      };
    case "DELETE":
      return {
        headers,
        method,
        data: params,
      };
    case "GET":
      return {
        headers,
        method,
      };
    default:
      return {
        headers,
        method,
        params,
      };
  }
};

const formatUrl = (params) => {
  let appId = getToken();
  let urlStr = `appId=${appId}`;
  for (var k in params) {
    let value = params[k] !== undefined ? params[k] : "";
    if (value) urlStr += "&" + k + "=" + encodeURIComponent(value);
  }
  return urlStr;
};

export { api, api1, formatParams, formatParams1, config, formatUrl };
