const env = process.env.NODE_ENV === "production";
// const publicPath = env ? "/manage-h5/" : "/"; //正式
const publicPath = env ? "/smartExam-h5/" : "/"; //测试

module.exports = {
  publicPath,
  productionSourceMap: !env,
  devServer: {
    open: true,
    hot: true,
    disableHostCheck: true,
    proxy: {
      "/baiduapi": {
        target: "https://apis.map.qq.com/",
        pathRewrite: {
          "^/baiduapi": "",
        },
      },
      "/api-admin": {
        target: "http://81.69.231.72:8881",
        changeOrigin: true,
        pathRewrite: {
          "^/api-admin": "",
        },
      },
      // 所属社区 网格信息
      "/appointment": {
        target: "https://appointment.smart-zj.cn/api/appointment/",
        changOrigin: true,
        pathRewrite: {
          "^/appointment": "",
        },
      },
      // 楼栋 房间信息
      "/comApplet": {
        // target: 'http://192.168.3.110:10013/comApplet/',  //测试地址
        target: "https://www.smart-zj.cn:55901/comApplet/",
        changOrigin: true,
        pathRewrite: {
          "^/comApplet": "",
        },
      },
    },
  },
  configureWebpack: {
    externals: {
      BMapGL: "BMapGL",
      AMap: "AMap",
      wx: "wx",
      AlipayJSBridge: "AlipayJSBridge",
      qq: "qq",
    },
  },
};
