import { api, formatParams } from "@/utils/axios";
// 生活地图--商家、居民申请列表
export function infoList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/information/listPage",
    })
  );
}
export function infoAdd(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/information/add",
    })
  );
}
export function infoEdit(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/information/edit?id=" + params.id,
    })
  );
}
export function infoDetail(params) {
  return api(
    Object.assign(formatParams("GET"), {
      url: `/admin-api/information/detail?id=${params}`,
    })
  );
}
// 菜单类别列表
export function menuCategoryList(params) {
  return api(
    Object.assign(formatParams("GET"), {
      url: `/admin-api/information/menuCategoryList?menuId=${params}`,
    })
  );
}
// 上线|下线
export function infoEnable(params) {
  return api(
    Object.assign(formatParams("GET"), {
      url: `/admin-api/information/enable?id=${params}`,
    })
  );
}
// 审核
export function infoReview(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `/admin-api/information/review`,
    })
  );
}
