import { api, formatParams, baseUrl } from '@/utils/axios'
import axios from 'axios'
import { getToken } from "@/utils/auth";


/**
 * 初审部门列表列表
 */

export function queryHouseListDeedTaxFromInitDepartment(params) {
    return api(
        Object.assign(formatParams("POST", params), {
            url: "/admin-api/improve-deedTax/queryListDeedTaxFromInitDepartment",
        })
    );
}

/**
 * 主审部门列表列表
 */
export function queryHouseListDeedTax(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/improve-deedTax/queryListDeedTax`
    }))
}

/**
 * 契税补贴查询详情
 */
 export function queryHouseDeedTaxDetailInfo(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/improve-deedTax/queryDeedTaxDetailInfo`
    }))
}

/**
 * 契税补贴查询操作记录
 */
 export function queryHouseDeedTaxRecord(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/improve-deedTax/queryDeedTaxRecord`
    }))
}

/**
 * 契税补贴初审部门审核
 */
 export function updateHouseInitDepartmentState(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/improve-deedTax/updateInitDepartmentState`
    }))
}

/**
 * 契税补贴主审部门审核
 */
 export function updateHouseDeedTaxState(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/improve-deedTax/updateDeedTaxState`
    }))
}

/**
 * 契税补贴初审部门撤回
 */
 export function initHouseDepartmentRevocation(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/improve-deedTax/initDepartmentRevocation`
    }))
}

/**
 * 契税补贴主审部门撤回
 */
 export function mainHouseRevocation(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/improve-deedTax/mainRevocation`
    }))
}

/**
 * 保存申请模板
 */
 export function saveHouseFileUrl(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/improve-deedTax/saveFileUrl`
    }))
}

/**
 * 修改申请单审核辖市区
 */
 export function updateHouseCheckArea(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/improve-deedTax/updateCheckArea`
    }))
}

/**
 * 导出
 */
 export function userHouseExport(params) {
    return axios({
        method: 'post',
        data: params,
        url: `${baseUrl}/admin-api/improve-deedTax/userExport`,
        responseType: 'blob',
        headers: {
            "Authorization": getToken() ? ( 'Bearer ' + getToken()) : "",
        }
    })
}

