import { api, formatParams } from "@/utils/axios";

// 操作手册--列表分页
export function instructList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/manual/listPage",
    })
  );
}
// 操作手册--新增
export function instructAdd(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/manual/add",
    })
  );
}
// 操作手册--编辑
export function instructEdit(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/manual/edit?id=" + params.id,
    })
  );
}
// 操作手册--启用｜禁用
export function instructEnable(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: "/admin-api/manual/enable?id=" + params,
    })
  );
}
// 操作手册--详情
export function instructDetail(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: "/admin-api/manual/detail?id=" + params,
    })
  );
}

// 操作手册内容--列表分页
export function contentList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/manual-content/listPage",
    })
  );
}
// 应用操作手册-内容--新增
export function contentAdd(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/manual-content/add",
    })
  );
}
// 应用操作手册-内容--编辑
export function contentEdit(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/manual-content/edit?id=" + params.id,
    })
  );
}
// 操作手册-内容--启用｜禁用
export function contentEnable(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: "/admin-api/manual-content/enable?id=" + params,
    })
  );
}
// 操作手册-内容--详情
export function contentDetail(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: "/admin-api/manual-content/detail?id=" + params,
    })
  );
}
