import { api, formatParams } from "@/utils/axios";
// 生活地图--商家、居民申请列表
export function applyList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/shopList",
    })
  );
}
// 生活地图--商家、居民申请  审核
export function applyReview(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/review",
    })
  );
}
// 详情
export function applyDetail(params) {
  return api(
    Object.assign(formatParams("GET"), {
      url: "/admin-api/living-circle/detail?shopId=" + params,
    })
  );
}
// 菜单
export function shopMenu() {
  return api(
    Object.assign(formatParams("GET"), {
      url: "/admin-api/living-circle/menu",
    })
  );
}
// 启用|禁用
export function shopEnable(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/enable",
    })
  );
}
// 邻里互助--商家、居民申请列表
export function helpList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle-mutual-aid/list",
    })
  );
}
// 邻里互助--商家、居民申请  审核
export function helpReview(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle-mutual-aid/review",
    })
  );
}
// 邻里互助--启用|禁用
export function helpEnable(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle-mutual-aid/enable",
    })
  );
}
// 邻里互助--详情
export function helpDetail(params) {
  return api(
    Object.assign(formatParams("GET"), {
      url: "/admin-api/living-circle-mutual-aid/comment?infoId=" + params,
    })
  );
}
// 类别
export function categoryList() {
  return api(
    Object.assign(formatParams("GET"), {
      url: "/admin-api/living-circle-mutual-aid/category",
    })
  );
}
// 类别列表
export function getCategory(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/categoryList",
    })
  );
}
// 类别新增
export function addCategory(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/addCategory",
    })
  );
}
// 类别编辑
export function editCategory(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/editCategory",
    })
  );
}
// 类别-启用|禁用
export function enableCategory(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/categoryEnable",
    })
  );
}

// 上传-图标
export function iconUpload(params) {
  let header = {
    "Content-Type": "multipart/form-data",
  };
  let formData = new FormData();
  formData.append("file", params);
  return api(
    Object.assign(formatParams("POST", formData, header), {
      url: `/admin-api/file/iconUpload`,
    })
  );
}
// 关键词列表
export function getKeyword(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/keywordList",
    })
  );
}
// 关键词新增
export function addKeyword(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/addKeyword",
    })
  );
}
// 关键词编辑
export function editKeyword(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/editKeyword",
    })
  );
}
// 关键词-启用|禁用
export function enableKeyword(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/keywordEnable",
    })
  );
}

// 关键词-删除
export function delKeyword(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: "/admin-api/living-circle/delKeyword",
    })
  );
}
