import { api, formatParams } from "@/utils/axios";
import { formatParams1, config } from "@/utils/request";

/**
 * 查询列表
 */
export function getList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/admin-api/talent/getList`,
    })
  );
}

/**
 * 查询详情
 */
export function get(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/admin-api/talent/get`,
    })
  );
}

/**
 * 查询类型
 */
export function getType(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: `${config.proxy}/admin-api/talent/getType?appId=1234`,
    })
  );
}

/**
 * 修改状态
 */
export function updateState(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}/admin-api/talent/updateState`,
    })
  );
}

/**
 * 操作记录
 */
export function getRecord(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}/admin-api/talent/getRecord`,
    })
  );
}

/**
 * 查询责任部门
 */
export function getBranch(params) {
  return api(
    Object.assign(formatParams1("GET", params), {
      url: `${config.proxy}/admin-api/talent/getBranch?appId=1234`,
    })
  );
}

/**
 * 修改学历状态
 */
export function educationState(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}/admin-api/talent/educationState`,
    })
  );
}

/**
 * 查看学历
 */
export function educationQuery(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}/admin-api/talent/getEducation`,
    })
  );
}
