import { api, formatParams, baseUrl } from '@/utils/axios'
// import { api1, formatParams1, config } from '@/utils/request'
import axios from 'axios'
import { getToken } from "@/utils/auth";


/**
 * 初审部门列表列表
 */

export function queryMultipleListDeedTaxFromInitDepartment(params) {
    return api(
        Object.assign(formatParams("POST", params), {
            url: "/admin-api/multipleChildren-deedTax/queryListDeedTaxFromInitDepartment",
        })
    );
}

/**
 * 主审部门列表列表
 */
export function queryMultipleListDeedTax(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/multipleChildren-deedTax/queryListDeedTax`
    }))
}

/**
 * 契税补贴查询详情
 */
 export function queryMultipleDeedTaxDetailInfo(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/multipleChildren-deedTax/queryDeedTaxDetailInfo`
    }))
}

/**
 * 契税补贴查询操作记录
 */
 export function queryMultipleDeedTaxRecord(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/multipleChildren-deedTax/queryDeedTaxRecord`
    }))
}

/**
 * 契税补贴初审部门审核
 */
 export function updateMultipleInitDepartmentState(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/multipleChildren-deedTax/updateInitDepartmentState`
    }))
}

/**
 * 契税补贴主审部门审核
 */
 export function updateMultipleDeedTaxState(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/multipleChildren-deedTax/updateDeedTaxState`
    }))
}

/**
 * 契税补贴初审部门撤回
 */
 export function initMultipleDepartmentRevocation(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/multipleChildren-deedTax/initDepartmentRevocation`
    }))
}

/**
 * 契税补贴主审部门撤回
 */
 export function mainMultipleRevocation(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/multipleChildren-deedTax/mainRevocation`
    }))
}

/**
 * 保存申请模板
 */
 export function saveMultipleFileUrl(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/multipleChildren-deedTax/saveFileUrl`
    }))
}

/**
 * 修改申请单审核辖市区
 */
 export function updateMultipleCheckArea(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/multipleChildren-deedTax/updateCheckArea`
    }))
}

/**
 * 导出
 */
 export function userMultipleExport(params) {
    return axios({
        method: 'post',
        data: params,
        url: `${baseUrl}/admin-api/multipleChildren-deedTax/userExport`,
        responseType: 'blob',
        headers: {
            "Authorization": getToken() ? ( 'Bearer ' + getToken()) : "",
        }
    })
}

/**
 * 契税补贴数据推送（至市契税）
 */
 export function dtSubsidy(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/dtSubsidy`
    }))
}