import { api, formatParams } from "@/utils/axios";
import { formatParams1, config } from "@/utils/request";
import axios from "axios";

/**
 * 列表
 */
export function getList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `/admin-api/cold/getList`,
    })
  );
}

/**
 * 查询详情
 */
export function detail(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `/admin-api/cold/get`,
    })
  );
}

/**
 * 自主申报列表
 */
export function getSelfList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `/admin-api/cold/getSelfList`,
    })
  );
}

/**
 * 自主申报详情
 */
export function selfDetail(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `/admin-api/cold/getSelf`,
    })
  );
}

/**
 * 修改自主申报状态
 */
export function updateSelf(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}admin-api/cold/updateSelf`,
    })
  );
}

/**
 * 仓库列表
 */
export function getAddress(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}admin-api/cold/getAddress`,
    })
  );
}

/**
 * 操作记录
 */
export function record(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}admin-api/cold/getRecord`,
    })
  );
}

/**
 * 修改申报单状态
 */
export function updateState(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}admin-api/cold/updateState`,
    })
  );
}

/**
 * 打印接口 老
 */
// export function getPrint(params) {
//   return api1(Object.assign(formatParams1('POST', params), {
//     url: `${config.proxy}cold/getPrinting`
//   }))
// }

/**
 * 打印接口 新
 */
export function getOutPrinting(params) {
  return axios.post(`${config.proxy}admin-api/cold/getOutPrinting`, params, {
    responseType: "blob",
  });
}

/**
 * 预约入库
 */
export function storageIn(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}admin-api/cold/storageIn`,
    })
  );
}

/**
 * 消杀出库
 */
export function storageOut(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}admin-api/cold/storageOut`,
    })
  );
}

/**
 * 入库审核
 */
export function storageVerify(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}admin-api/cold/storageVerify`,
    })
  );
}

/**
 * 获取统计申报数量
 */
export function getQuantity(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}admin-api/cold/getQuantity`,
    })
  );
}

/**
 * 获取统计消杀和检测
 */
export function getDisinfect(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}admin-api/cold/getDisinfect`,
    })
  );
}

/**
 * 查询区域
 */
export function getArea() {
  return api(
    Object.assign(formatParams1("GET"), {
      url: `${config.proxy}admin-api/cold/getArea?type=2`,
    })
  );
}

/**
 * 统计出库数据
 */
export function getDelivery(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}admin-api/cold/getDelivery`,
    })
  );
}
