import {
    api,
    formatParams
} from "@/utils/axios";



// 获取用户列表
export function userPage(params) {
    return api(
        Object.assign(formatParams("GET", params), {
            url: `/admin-api/system/user/page`
        })
    );
}

// 创建用户
export function createUser(params) {
    return api(
        Object.assign(formatParams("POST", params), {
            url: "/admin-api/system/user/create",
        })
    );
}

// 修改用户密码
export function updatePassword(params) {
    return api(
        Object.assign(formatParams("PUT", params), {
            url: "/admin-api/system/user/update-password",
        })
    );
}

// 获取角色列表
export function listAllRole(params) {
    return api(
        Object.assign(formatParams("GET", params), {
            url: "/admin-api/system/role/list-all-simple",
        })
    );
}

// 赋予用户角色权限
export function updateRole(params) {
    return api(
        Object.assign(formatParams("PUT", params), {
            url: "/admin-api/system/user/update-role",
        })
    );
}

// 删除用户
export function deleteUser(params) {
    return api(
        Object.assign(formatParams("DELETE", params), {
            url: `/admin-api/system/user/delete?id=${params.id}`
        })
    );
}