import Vue from 'vue'
import VueRouter from 'vue-router'
import Login from '../views/Login'

Vue.use(VueRouter)
const routes = [{
        path: '/login',
        name: 'login',
        component: Login
    },
    {
        path: "*",
        name: "layout",
        redirect: "/home",
        component: () =>
            import( /* webpackChunkName: "layout" */ "@/layout/index.vue"),
        children: [{
                path: "/home",
                name: "home",
                component: () =>
                    import( /* webpackChunkName: "home" */ "@/views/Home/index.vue"),
                meta: ["首页"],
            }, 
            // 角色管理
            {
                path: "/role",
                name: "role",
                component: () =>
                    import( /* webpackChunkName: "home" */ "@/views/Role/index.vue"),
                meta: ["系统管理"],
            }, 
            // 用户管理
            {
                path: "/user",
                name: "user",
                component: () =>
                    import( /* webpackChunkName: "home" */ "@/views/User/index.vue"),
                meta: ["系统管理"],
            }, 
            // 菜单管理
            {
                path: "/menu",
                name: "menu",
                component: () =>
                    import( /* webpackChunkName: "home" */ "@/views/Menu/index.vue"),
                meta: ["系统管理"],
            }, 
            // 80%契税补贴
            {
                path: "/deedtax",
                name: "deedtax",
                component: () =>
                    import( /* webpackChunkName: "home" */ "@/views/Deedtax/index.vue"),
                meta: ["80%契税补贴"],
            }, {
                path: "/deedtax-house",
                name: "deedtaxHouse",
                component: () =>
                    import( /* webpackChunkName: "home" */ "@/views/Deedtax/house.vue"),
                meta: ["80%契税补贴"],
            }, 
            // 人才政策管理
            {
                path: "/policy",
                name: "policy",
                component: () =>
                    import( /* webpackChunkName: "home" */ "@/views/Policy/index.vue"),
                meta: ["人才政策管理"],
            }, {
                path: "/policy-guide",
                name: "policyGuide",
                component: () =>
                    import( /* webpackChunkName: "home" */ "@/views/Policy/guide.vue"),
                meta: ["人才政策管理"],
            }, 
            // 100%契税补贴
            {
                path: '/policy-house',
                name: 'policyHouse',
                component: () => import('@/views/Policy/house.vue'),
                meta: ["100%契税补贴"],
            }, {
                path: '/policy-house-main',
                name: 'policyHouseMain',
                component: () => import('@/views/Policy/housemain.vue'),
                meta: ["100%契税补贴"],
            }, {
                path: '/talent-window',
                name: 'talentWindow',
                component: () => import('@/views/Policy/talentwindow.vue'),
                meta: ["100%契税补贴"],
            },
            // 购房补贴政策管理
            //住建局
            {
                path: '/purchase',
                name: 'purchaseIndex',
                component: () => import('@/views/Purchase/index.vue'),
                meta: ["购房补贴政策管理"],
            },
            //四个部门
            {
                path: '/purchase-details',
                name: 'purchaseDetails',
                meta: ['购房补贴政策管理'],
                component: () => import('@/views/Purchase/details')
            },
            //人才窗口
            {
                path: '/purchase-windows',
                name: 'purchaseWindows',
                meta: ['购房补贴政策管理'],
                component: () => import('@/views/Purchase/windows')
            },
            // 冷链食品申报
            {
                path: '/coldfood',
                name: 'coldFood',
                meta: ['冷链食品'],
                component: () => import('@/views/Coldfood/index.vue')
            },
            // 冷链食品自主申报
            {
                path: '/selfreport',
                name: 'selfReport',
                meta: ['冷链食品'],
                component: () => import('@/views/Coldfood/selfReport')
            },
            // 冷链食品数据统计
            {
                path: '/coldfood-statistics',
                name: 'coldfoodStatistics',
                meta: ['冷链食品'],
                component: () => import('@/views/Coldfood/statistics')
            },
            // 冷链食品商品流向分析
            {
                path: '/coldfood-flow',
                name: 'coldfoodFlow',
                meta: ['冷链食品'],
                component: () => import('@/views/Coldfood/flowAnalysis')
            },
            // 人才码
            {
                path: '/talents',
                name: 'talents',
                meta: ['人才码申报管理'],
                component: () => import('@/views/Talents/index.vue')
            },
            // 通用管理
            // 登录用户管理
            {
                path: '/loginUser',
                name: 'loginUser',
                meta: ['通用管理'],
                component: () => import('@/views/Currency/loginUser.vue')
            },
            // 实名用户管理
            {
                path: '/realUser',
                name: 'realUser',
                meta: ['通用管理'],
                component: () => import('@/views/Currency/realUser.vue')
            },
        ]

    },
]
const router = new VueRouter({
    mode: 'hash',
    base: process.env.BASE_URL,
    routes
})
const routerPush = VueRouter.prototype.push;
VueRouter.prototype.push = function push(location) {
    return routerPush.call(this, location).catch((error) => error);
};
export default router