import Vue from "vue";
import App from "./App";
import router from "./router";
import ElementUI from "element-ui";
import "element-ui/lib/theme-chalk/index.css";
import { getToken } from "./utils/auth";
import "default-passive-events";
import store from "./store";

Vue.use(ElementUI);
Vue.config.productionTip = false;

const whiteList = ["/login"]; // 不重定向白名单
router.beforeEach((to, from, next) => {
  if (getToken()) {
    if (to.path == "/login") {
      next("/home");
    } else {
      next();
    }
  } else {
    if (whiteList.indexOf(to.path) !== -1) {
      next();
    } else {
      next("/login");
    }
  }
});

new Vue({
  el: "#app",
  router,
  store,
  render: (h) => h(App),
});
