import { api, formatParams } from "@/utils/axios";
import { api1, formatParams1, config } from "@/utils/request";
// import { baseUrl } from '@/config/index'

/**
 * 查询列表
 */
export function getList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/admin-api/familyCode/queryList`,
    })
  );
}

/**
 * 查询详情
 */
export function get(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: `${config.proxy}/admin-api/talent/detail`,
    })
  );
}
/**
 * 查询详情
 */
export function getFamily(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: `${config.proxy}/admin-api/familyCode/detail`,
    })
  );
}
/**
 * 查询类型
 */
export function getType() {
  return api(
    Object.assign(formatParams("POST"), {
      url: `${config.proxy}/admin-api/familyCode/queryZjCity`,
    })
  );
}

/**
 * 查询状态
 */
export function getReviewState(params) {
  return api(
    Object.assign(formatParams("GET"), {
      url: `${config.proxy}/admin-api/familyCode/reviewState?type=${params}`,
    })
  );
}
// 审核
export function familyAudit(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/admin-api/familyCode/review`,
    })
  );
}

/**
 * 修改状态
 */
export function updateState(params) {
  return api1(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}talent/updateState`,
    })
  );
}
/**
 * 审核改派
 */
export function auditUpdate(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}/admin-api/familyCode/reassignment`,
    })
  );
}
/**
 * 操作记录
 */
export function getRecord(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: `${config.proxy}/admin-api/familyCode/queryRecordList`,
    })
  );
}

/**
 * 查询责任部门
 */
export function getBranch(params) {
  return api1(
    Object.assign(formatParams1("GET", params), {
      url: `${config.proxy}talent/getBranch?appId=1234`,
    })
  );
}

/**
 * 修改学历状态
 */
export function educationState(params) {
  return api1(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}talent/educationState`,
    })
  );
}

/**
 * 查看学历
 */
export function educationQuery(params) {
  return api1(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}talent/getEducation`,
    })
  );
}
