import { api, formatParams, baseUrl } from '@/utils/axios'
// import { api1, formatParams1, config } from '@/utils/request'
import axios from 'axios'
import { getToken } from "@/utils/auth";


/**
 * 初审部门列表列表
 */

export function queryCommerListDeedTaxFromInitDepartment(params) {
    return api(
        Object.assign(formatParams("POST", params), {
            url: "/admin-api/commercial-deedTax/queryListDeedTaxFromInitDepartment",
        })
    );
}

/**
 * 主审部门列表列表
 */
export function queryCommerListDeedTax(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/commercial-deedTax/queryListDeedTax`
    }))
}

/**
 * 契税补贴查询详情
 */
 export function queryCommerDeedTaxDetailInfo(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/commercial-deedTax/queryDeedTaxDetailInfo`
    }))
}

/**
 * 契税补贴查询操作记录
 */
 export function queryCommerDeedTaxRecord(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/commercial-deedTax/queryDeedTaxRecord`
    }))
}

/**
 * 契税补贴初审部门审核
 */
 export function updateCommerInitDepartmentState(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/commercial-deedTax/updateInitDepartmentState`
    }))
}

/**
 * 契税补贴主审部门审核
 */
 export function updateCommerDeedTaxState(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/commercial-deedTax/updateDeedTaxState`
    }))
}

/**
 * 契税补贴初审部门撤回
 */
 export function initCommerDepartmentRevocation(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/commercial-deedTax/initDepartmentRevocation`
    }))
}

/**
 * 契税补贴主审部门撤回
 */
 export function mainCommerRevocation(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/commercial-deedTax/mainRevocation`
    }))
}

/**
 * 保存申请模板
 */
 export function saveCommerFileUrl(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/commercial-deedTax/saveFileUrl`
    }))
}

/**
 * 修改申请单审核辖市区
 */
 export function updateCommerCheckArea(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/commercial-deedTax/updateCheckArea`
    }))
}

/**
 * 导出
 */
 export function userCommerExport(params) {
    return axios({
        method: 'post',
        data: params,
        url: `${baseUrl}/admin-api/commercial-deedTax/userExport`,
        responseType: 'blob',
        headers: {
            "Authorization": getToken() ? ( 'Bearer ' + getToken()) : "",
        }
    })
}

/**
 * 契税补贴数据推送（至市契税）
 */
 export function dtSubsidy(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/dtSubsidy`
    }))
}