import {
    api,
    formatParams
} from "@/utils/axios";

// 获取菜单精简信息
export function listAllSimple() {
    return api(
        Object.assign(formatParams("GET"), {
            url: "/admin-api/system/menu/listAllSimple",
        })
    );
}

// 创建菜单
export function createMenu(params) {
    return api(
        Object.assign(formatParams("POST", params), {
            url: "/admin-api/system/menu/create",
        })
    );
}

// 修改菜单
export function updateMenu(params) {
    return api(
        Object.assign(formatParams("PUT", params), {
            url: `/admin-api/system/menu/update?id=${params.id}`
        })
    );
}

// 删除菜单
export function deleteMenu(params) {
    return api(
        Object.assign(formatParams("DELETE", params), {
            url: `/admin-api/system/menu/delete?id=${params.id}`
        })
    );
}