import {
    api,
    formatParams
} from "@/utils/axios";

// 获取菜单精简信息
export function rolePage(params) {
    return api(
        Object.assign(formatParams("GET", params), {
            url: `/admin-api/system/role/page`
        })
    );
}

// 创建角色
export function createRole(params) {
    return api(
        Object.assign(formatParams("POST", params), {
            url: "/admin-api/system/role/create",
        })
    );
}

// 获取角色已分配菜单列表
export function listRoleMenu(params) {
    return api(
        Object.assign(formatParams("GET", params), {
            url: "/admin-api/system/menu/listRoleMenu",
        })
    );
}

// 赋予角色菜单
export function assignRoleMenu(params) {
    return api(
        Object.assign(formatParams("POST", params), {
            url: "/admin-api/system/permission/assign-role-menu",
        })
    );
}

// 删除用户
export function deleteUser(params) {
    return api(
        Object.assign(formatParams("DELETE", params), {
            url: `/admin-api/system/role/delete?id=${params.id}`
        })
    );
}