// import { uploadImg, uploadVideo, uploadFile } from '@/api/upload'
import CryptoJS from "crypto-js";

/**
 * @param {Function} func
 * @param {number} wait
 * @param {boolean} immediate
 * @return {*}
 */
export function debounce(func, wait, immediate) {
  let timeout, args, context, timestamp, result

  const later = function () {
    // 据上一次触发时间间隔
    const last = +new Date() - timestamp

    // 上次被包装函数被调用时间间隔 last 小于设定时间间隔 wait
    if (last < wait && last > 0) {
      timeout = setTimeout(later, wait - last)
    } else {
      timeout = null
      // 如果设定为immediate===true，因为开始边界已经调用过了此处无需调用
      if (!immediate) {
        result = func.apply(context, args)
        if (!timeout) context = args = null
      }
    }
  }

  return function (...args) {
    context = this
    timestamp = +new Date()
    const callNow = immediate && !timeout
    // 如果延时不存在，重新设定延时
    if (!timeout) timeout = setTimeout(later, wait)
    if (callNow) {
      result = func.apply(context, args)
      context = args = null
    }

    return result
  }
}

/**
 * 设置浏览器头部标题
 */
export const setTitle = (title) => {
  title = title ? `${title}` : '网上考试管理后台'
  window.document.title = title
}

/**
 * 选项与数字的枚举
 */
export const enumeration = {
  1: 'A',
  2: 'B',
  3: 'C',
  4: 'D',
  5: 'E',
  6: 'F',
  7: 'G',
  8: 'H',
  9: 'I',
  10: 'J',
  11: 'K',
  12: 'L',
  13: 'M',
  14: 'N',
  15: 'O',
  16: 'P',
  17: 'Q',
  18: 'R',
  19: 'S',
  20: 'T',
  21: 'U',
  22: 'V',
  23: 'W',
  24: 'X',
  25: 'Y',
  26: 'Z'
}

/**
 * 上传文件
 */
// export function uploadMixFile(file, type) {
//   let fun = new Promise((resolve, reject) => {
//     if (type === "image") {
//       uploadImg(file).then(
//         res => {
//           if (res.success) {
//             resolve(res.data);
//           } else {
//             reject(res.msg);
//           }
//         },
//         error => {
//           reject(error);
//         }
//       );
//     } else if (type === "video") {
//       uploadVideo(file).then(
//         res => {
//           if (res.success) {
//             resolve(res.data);
//           } else {
//             reject(res.msg);
//           }
//         },
//         error => {
//           reject(error);
//         }
//       );
//     } else if (type === 'file') {
//       uploadFile(file).then(
//         res => {
//           if (res.success) {
//             resolve(res.data);
//           } else {
//             reject(res.msg);
//           }
//         },
//         error => {
//           reject(error);
//         }
//       );
//     }
//   });
//   return fun;
// }

export function getQueryString(name) {
  console.log('获取到的name---', name);
  const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i');
  const r = window.location.search.substr(1).match(reg);
  console.log('r---', r);
  if (r != null) {
    return r[2];
  }
  return null;
}




export function fromDate(timestamp) {
  const time = new Date(timestamp);
  const yy = time.getFullYear().toString(); //年
  let MM = time.getMonth() + 1; //月
  MM = MM < 10 ? ('0' + MM) : MM;
  let dd = time.getDate(); //日
  dd = dd < 10 ? ('0' + dd) : dd;
  return `${yy}-${MM}-${dd}`
}

export function changeList(list) {
  list.map((item) => {
    if (item.name) {
      item.name = setName(item.name)
    }
    if (item.contactUser) {
      item.contactUser = setName(item.contactUser)
    }
    if (item.phone) {
      item.phone = setTel(item.phone)
    }
    if (item.contactMobile) {
      item.contactMobile = setTel(item.contactMobile)
    }
    if (item.mobile) {
      item.mobile = setTel(item.mobile)
    }
    if (item.idCard) {
      item.idCard = setCertNo(item.idCard)
    }
    return item
  })
  return list
}

export function setName(str) {
  if (str) {
    let str1 = str.substr(0, 1);
    let num1 = str.substr(1).length;
    let str2 = ''
    for (let i = 0; i < num1; i++) {
      str2 += ' *'
    }
    let str3 = str1 + str2;
    return str3;
  } else {
    return '-'
  }
}

export function setTel(tel) {
  if (tel && tel.length >= 11) {
    var pat = /(\d{3})\d*(\d{4})/
    let telFinal = tel.replace(pat, '$1****$2');
    return telFinal
  } else {
    return '-';
  }
}

export function setCertNo(certNo) {
  if (certNo && certNo.length >= 10) {
    var certNo1 = certNo.trim();
    // let cert1 = certNo.substring(0, certNo.length-4);
    // let cert2 = cert1 + "****";
    // return cert2;
    // let cert1 = certNo.replace(/(\w{6})\w{2}(\w{6})\w{4}/, '$1**$2****');
    let cert1 = certNo1.substring(0, 6) + '********' + certNo1.substring(14, certNo1.length);
    return cert1;
  } else {
    return '-';
  }
}
// 解密
export function decryptByDES(ciphertext, key) {
  const keyHex = CryptoJS.enc.Utf8.parse(key);
  const decrypted = CryptoJS.DES.decrypt({
      ciphertext: CryptoJS.enc.Base64.parse(ciphertext),
    },
    keyHex, {
      mode: CryptoJS.mode.ECB,
      padding: CryptoJS.pad.Pkcs7,
    }
  );
  return decrypted.toString(CryptoJS.enc.Utf8);
}
// 加密
export function encryptByDES(message, key) {
  const keyHex = CryptoJS.enc.Utf8.parse(key); // 秘钥
  let newMessage = "" + message;
  const encrypted = CryptoJS.DES.encrypt(newMessage, keyHex, {
    mode: CryptoJS.mode.ECB, // 加密模式
    padding: CryptoJS.pad.Pkcs7,
  });
  return encrypted.toString(); //  加密出来为 hex格式密文
}