import axios from "axios";
import { baseUrl } from "@/config";
import { getToken } from "@/utils/auth";
import router from "@/router";
const api = axios.create({
  baseURL: `${baseUrl}`,
  timeout: 60000,
});
// 请求拦截
api.interceptors.request.use(
  (config) => {
    let appId = /*getToken()*/ "1234";
    if (config.data) config.data.appId = appId;
    return config;
  },
  (error) => ({ status: 0, msg: error.message })
);
// 请求返回
api.interceptors.response.use(
  (response) => {
    return Promise.resolve(response).then(checkCode);
  },
  (error) => {
    let msg = "";
    if (error.response && error.response.data && error.response.data.message) {
      msg = error.response.data.message;
    } else {
      msg = "系统错误";
    }
    const returnData = {
      success: false,
      code: -1,
      msg: msg,
    };
    // token失效返回登陆页面
    if (
      error.response &&
      error.response.data &&
      error.response.data.status &&
      error.response.data.status == 500
    ) {
      window.localStorage.clear();
      router.push("/login");
    }
    return Promise.resolve(returnData);
  }
);
// 后台自定义 code错误处理
const checkCode = (res) => {
  if (res) {
    if (res.data.code == 200 || res.data.code == 0) {
      //code为0成功
      const returnData = {
        code: 200,
        success: true,
        data: res.data.data || res,
        msg: res.data.message,
      };
      return returnData;
    } else {
      //统一处理错误
      const returnData = {
        success: false,
        code: res.data.code,
        msg: res.data.msg,
      };
      return returnData;
    }
  } else {
    const returnData = {
      success: false,
      code: -1,
      msg: "没有返回值",
    };
    return returnData;
  }
};
// 解析参数
const formatParams = (method = "GET", params, type) => {
  let contentType = "";
  //headers配置token
  if (type == "file") {
    //文件配置
    contentType = "multipart/form-data";
  } else if (type == "qs") {
    contentType = "application/x-www-form-urlencoded;charset=utf-8";
  } else {
    //普通接口配置
    contentType = "application/json;charset=utf-8";
  }
  let headers = {
    "Content-Type": contentType,
    "Authorization": getToken() ? ( 'Bearer ' + getToken()) : "",
  };
  // appId设置
  // 如果接口需要序列化 type == 'qs'
  if (type == "qs") {
    var tempParams = new URLSearchParams();
    Object.keys(params).map((el) => {
      tempParams.append(`${el}`, params[el]);
    });
    params = tempParams;
    return {
      headers,
      method,
      data: params,
    };
  }
  switch (method) {
    case "POST":
    case "DOWNLOAD":
      return {
        responseType: type,
        headers,
        method: "POST",
        data: params,
      };
    case "PUT":
      return {
        responseType: type,
        headers,
        method,
        data: params,
      };
    case "DELETE":
      return {
        responseType: type,
        headers,
        method,
        data: params,
      };
    case "GET":
      return {
        headers,
        method,
        params,
      };
    default:
      return {
        headers,
        method,
        params,
      };
  }
};

export { api, formatParams, baseUrl };