import { api1, formatParams1, config } from '@/utils/request'
import { getToken } from '@/utils/auth'

/**
 * 上传图片
 */
export function uploadImg(params) {
  let header = {
    'Content-Type': 'multipart/form-data'
  }
  let formData = new FormData();
  formData.append('file', params);
  return api1(Object.assign(formatParams1('POST', formData, header), {
    url: `${config.proxy}file/uploadImg`
  }))
}

/**
 * 上传课件
 */
export function uploadVideo(params) {
  let header = {
    'Content-Type': 'multipart/form-data'
  }
  let formData = new FormData();
  formData.append('file', params);
  return api1(Object.assign(formatParams1('POST', formData, header), {
    url: `${config.proxy}file/examVideo`
  }))
}

/**
 * 上传文件
 */
export function uploadFile(params) {
  console.log('params---',params);
  
  let header = {
    'Content-Type': 'multipart/form-data'
  }
  let formData = new FormData();
  formData.append('file', params);
  return api1(Object.assign(formatParams1('POST', formData, header), {
    url: `${config.proxy}file/examFile`
  }))
}

/**
 * 上传文件
 */
 export function uploadWordFile(params) {
  console.log('params---',params);
  
  let header = {
    'Content-Type': 'multipart/form-data'
  }
  let formData = new FormData();
  formData.append('file', params);
  return api1(Object.assign(formatParams1('POST', formData, header), {
    url: `${config.proxy}file/uploadWordFile`
    // url: `${config.proxy}file/deedTaxWorldUpload`
  }))
}

/**
 * 创建题库
 */
export function excelEntrance(params) {
  let header = {
    'Content-Type': 'multipart/form-data'
  }
  let formData = new FormData();
  formData.append('file', params.file);
  formData.append('appId', getToken());
  formData.append('name', params.name);
  return api1(Object.assign(formatParams1('POST', formData, header), {
    url: `${config.proxy}excelFile/excelEntrance`
  }))
}
