import { api, formatParams } from "@/utils/axios";
import { formatParams1, config } from "@/utils/request";
// import { baseUrl } from '@/config/index'

/**
 * 查询列表
 */
export function getList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/admin-api/familyCode/queryList`,
    })
  );
}

/**
 * 查询详情
 */
export function getFamily(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: `${config.proxy}/admin-api/familyCode/detail`,
    })
  );
}
/**
 * 查询类型
 */
export function getType() {
  return api(
    Object.assign(formatParams("POST"), {
      url: `${config.proxy}/admin-api/familyCode/queryZjCity`,
    })
  );
}

/**
 * 查询状态
 */
export function getReviewState(params) {
  return api(
    Object.assign(formatParams("GET"), {
      url: `${config.proxy}/admin-api/familyCode/reviewState?type=${params}`,
    })
  );
}
// 审核
export function familyAudit(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/admin-api/familyCode/review`,
    })
  );
}

/**
 * 审核改派
 */
export function auditUpdate(params) {
  return api(
    Object.assign(formatParams1("POST", params), {
      url: `${config.proxy}/admin-api/familyCode/reassignment`,
    })
  );
}
/**
 * 操作记录
 */
export function getRecord(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: `${config.proxy}/admin-api/familyCode/queryRecordList`,
    })
  );
}
