import { api, formatParams, baseUrl } from '@/utils/axios'
// import { api1, formatParams1, config } from '@/utils/request'
import axios from 'axios'
import { getToken } from "@/utils/auth";


/**
 * 初审部门列表列表
 */

export function queryListDeedTaxFromInitDepartment(params) {
    return api(
        Object.assign(formatParams("POST", params), {
            url: "/admin-api/deedTax/queryListDeedTaxFromInitDepartment",
        })
    );
}

/**
 * 主审部门列表列表
 */
export function queryListDeedTax(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/queryListDeedTax`
    }))
}

/**
 * 契税补贴查询详情
 */
 export function queryDeedTaxDetailInfo(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/queryDeedTaxDetailInfo`
    }))
}

/**
 * 契税补贴查询操作记录
 */
 export function queryDeedTaxRecord(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/queryDeedTaxRecord`
    }))
}

/**
 * 契税补贴初审部门审核
 */
 export function updateInitDepartmentState(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/updateInitDepartmentState`
    }))
}

/**
 * 契税补贴主审部门审核
 */
 export function updateDeedTaxState(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/updateDeedTaxState`
    }))
}

/**
 * 契税补贴初审部门撤回
 */
 export function initDepartmentRevocation(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/initDepartmentRevocation`
    }))
}

/**
 * 契税补贴主审部门撤回
 */
 export function mainRevocation(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/mainRevocation`
    }))
}

/**
 * 保存申请模板
 */
 export function saveFileUrl(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/saveFileUrl`
    }))
}

/**
 * 修改申请单审核辖市区
 */
 export function updateCheckArea(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/updateCheckArea`
    }))
}

/**
 * 导出
 */
 export function userExport(params) {
    return axios({
        method: 'post',
        data: params,
        url: `${baseUrl}/admin-api/deedTax/userExport`,
        responseType: 'blob',
        headers: {
            "Authorization": getToken() ? ( 'Bearer ' + getToken()) : "",
        }
    })
}

/**
 * 契税补贴数据推送（至市契税）
 */
 export function dtSubsidy(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/deedTax/dtSubsidy`
    }))
}