import {
    api,
    formatParams
} from "@/utils/axios";
import {
    api1,
    formatParams1,
    config
} from '@/utils/request'

/**
 * 购房契税补贴住建局审核申请列表
 * @param {*} params 
 * @returns 
 */
export function mattersHousingList(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/housing/mattersHousingList`
    }))
}

/**
 * 购房契税补贴其他局审核申请列表
 * @param {*} params 
 * @returns 
 */
export function mattersHousingReviewerList(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/housing/mattersHousingReviewerList`
    }))
}

/**
 * 列表
 */
export function mattersParentList(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/parent/mattersParentList`
    }))
}

/**
 * 详情
 */
export function mattersGet(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/parent/mattersGet`
    }))
}

/**
 * 修改状态
 */
export function mattersUpdateState(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersUpdateState`
    }))
}

/**
 * 查询人才政策指南列表
 * @returns <promise>
 */
export function mattersGuideList(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersGuideList`
    }))
}

/**
 * 人才事项部门列表
 */
export function mattersDepartmentList(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersDepartmentList`
    }))
}

/**
 * 查询人才政策指南详情
 * @returns 
 */
export function mattersGuideGet(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersGuideGet`
    }))
}

/**
 * 添加人才政策指南
 * @returns <promise>
 */
export function mattersGuideAdd(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersGuideAdd`
    }))
}

/**
 * 修改人才政策指南
 * @param {*} params 
 * @returns 
 */
export function mattersGuideUpdate(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersGuideUpdate`
    }))
}

/**
 * 删除人才政策指南
 * @returns <promise>
 */
export function mattersGuideDelete(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersGuideDelete`
    }))
}

/**
 * 购房契税补贴其他局审核状态修改
 * @param {*} params 
 * @returns 
 */
export function mattersHousingReviewerUpdate(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersHousingReviewerUpdate`
    }))
}

/**
 * 购房契税补贴住建局修改状态
 * @param {*} params 
 * @returns 
 */
export function mattersHousingUpdate(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersHousingUpdate`
    }))
}

/**
 * 记录
 */
export function mattersGetReason(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersGetReason`
    }))
}

/**
 * 购房契税补贴申请详情
 * @param {*} params 
 * @returns 
 */
export function mattersHousingGet(params) {
    return api(Object.assign(formatParams('GET', params), {
        url: `/admin-api/housing/mattersHousingGet`
    }))
}

/**
 * 购房契税补贴其他局审核操作记录
 * @param {*} params 
 * @returns 
 */
export function mattersHousingReason(params) {
    return api1(Object.assign(formatParams1('POST', params), {
        url: `${config.proxy}talent/mattersHousingReason`
    }))
}