import {
    api,
    formatParams,
    baseUrl
} from "@/utils/axios";
import axios from 'axios'
import { getToken } from "@/utils/auth";

// 核酸采样码
// 获取列表
export function getListCommunityDeclarationUser(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/nucleicAcid/getListCommunityDeclarationUser`
    }))
}

// 获取详情
export function getDetailInfo(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/nucleicAcid/getDetailInfo`
    }))
}

// 新增社区代报采样码
export function addCommunityDeclarationUser(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/nucleicAcid/addCommunityDeclarationUser`
    }))
}

// 修改社区代报采样码
export function updateCommunityDeclarationUser(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/nucleicAcid/updateCommunityDeclarationUser`
    }))
}


// 核酸采样结果
// 获取列表
export function getList(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/nucleicAcidResult/getList`
    }))
}

// 导入excel
 export function exportAdd(params) {
    return axios({
        method: 'post',
        data: params,
        url: `${baseUrl}/admin-api/nucleicAcidResult/exportAdd`,
        responseType: 'blob',
        headers: {
            "Authorization": getToken() ? ( 'Bearer ' + getToken()) : "",
        }
    })
}

// 获取详情
export function getResultDetail(params) {
    return api(Object.assign(formatParams('GET', params), {
        url: `/admin-api/nucleicAcidResult/getResultDetail`
    }))
}

// 新增
export function customAdd(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/nucleicAcidResult/customAdd`
    }))
}

// 修改
export function update(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/nucleicAcidResult/update`
    }))
}