import Vue from "vue";
import VueRouter from "vue-router";
import Login from "../views/Login";

Vue.use(VueRouter);
const routes = [
  {
    path: "/login",
    name: "login",
    component: Login,
  },
  {
    path: "*",
    name: "layout",
    redirect: "/home",
    component: () =>
      import(/* webpackChunkName: "layout" */ "@/layout/index.vue"),
    children: [
      {
        path: "/home",
        name: "home",
        component: () =>
          import(/* webpackChunkName: "home" */ "@/views/Home/index.vue"),
        meta: ["首页"],
      },
      // 角色管理
      {
        path: "/role",
        name: "role",
        component: () =>
          import(/* webpackChunkName: "home" */ "@/views/Role/index.vue"),
        meta: ["系统管理"],
      },
      // 用户管理
      {
        path: "/user",
        name: "user",
        component: () =>
          import(/* webpackChunkName: "home" */ "@/views/User/index.vue"),
        meta: ["系统管理"],
      },
      // 菜单管理
      {
        path: "/menu",
        name: "menu",
        component: () =>
          import(/* webpackChunkName: "home" */ "@/views/Menu/index.vue"),
        meta: ["系统管理"],
      },
      // 80%契税补贴
      {
        path: "/deedtax",
        name: "deedtax",
        component: () =>
          import(/* webpackChunkName: "home" */ "@/views/Deedtax/index.vue"),
        meta: ["80%契税补贴"],
      },
      {
        path: "/deedtax-house",
        name: "deedtaxHouse",
        component: () =>
          import(/* webpackChunkName: "home" */ "@/views/Deedtax/house.vue"),
        meta: ["80%契税补贴"],
      },
      {
        path: "/deedtax-dyhouse",
        name: "deedtaxDyHouse",
        component: () =>
          import(/* webpackChunkName: "home" */ "@/views/Deedtax/dy_house.vue"),
        meta: ["80%契税补贴"],
      },
      //商业契税补贴
      {
        path: "/commercialdeedtax",
        name: "commercialdeedtax",
        component: () =>
          import(
            /* webpackChunkName: "home" */ "@/views/Commercialdeedtax/index.vue"
          ),
        meta: ["商业契税补贴"],
      },
      {
        path: "/commercial-deedtax-house",
        name: "commercialdeedtaxHouse",
        component: () =>
          import(
            /* webpackChunkName: "home" */ "@/views/Commercialdeedtax/house.vue"
          ),
        meta: ["商业契税补贴"],
      },
      {
        path: "/commercial-deedtax-dyhouse",
        name: "commercialdeedtaxDyHouse",
        component: () =>
          import(
            /* webpackChunkName: "home" */ "@/views/Commercialdeedtax/dy_house.vue"
          ),
        meta: ["商业契税补贴"],
      },
      //多子女契税补贴
      {
        path: "/multipledeedtax",
        name: "multipledeedtax",
        component: () =>
          import(
            /* webpackChunkName: "home" */ "@/views/Multipledeedtax/index.vue"
          ),
        meta: ["多子女契税补贴"],
      },
      {
        path: "/multiple-deedtax-dyhouse",
        name: "multipledeedtaxDyHouse",
        component: () =>
          import(
            /* webpackChunkName: "home" */ "@/views/Multipledeedtax/dy_house.vue"
          ),
        meta: ["多子女契税补贴"],
      },
      {
        path: "/multiple-deedtax-house",
        name: "multipledeedtaxHouse",
        component: () =>
          import(
            /* webpackChunkName: "home" */ "@/views/Multipledeedtax/house.vue"
          ),
        meta: ["多子女契税补贴"],
      },
      //改善住房契税补贴
      {
        path: "/housingimprovementdeedtax",
        name: "housingimprovementdeedtax",
        component: () =>
          import(
            /* webpackChunkName: "home" */ "@/views/Housedeedtax/index.vue"
          ),
        meta: ["改善住房契税补贴"],
      },
      {
        path: "/housingimprovement-deedtax-house",
        name: "housingimprovementdeedtaxHouse",
        component: () =>
          import(
            /* webpackChunkName: "home" */ "@/views/Housedeedtax/house.vue"
          ),
        meta: ["改善住房契税补贴"],
      },
      {
        path: "/housingimprovement-deedtax-dyhouse",
        name: "housingimprovementdeedtaxDyHouse",
        component: () =>
          import(
            /* webpackChunkName: "home" */ "@/views/Housedeedtax/dy_house.vue"
          ),
        meta: ["改善住房契税补贴"],
      },
      // 人才政策管理
      {
        path: "/policy",
        name: "policy",
        component: () =>
          import(/* webpackChunkName: "home" */ "@/views/Policy/index.vue"),
        meta: ["人才政策管理"],
      },
      {
        path: "/policy-guide",
        name: "policyGuide",
        component: () =>
          import(/* webpackChunkName: "home" */ "@/views/Policy/guide.vue"),
        meta: ["人才政策管理"],
      },
      // 100%契税补贴
      {
        path: "/policy-house",
        name: "policyHouse",
        component: () => import("@/views/Policy/house.vue"),
        meta: ["100%契税补贴"],
      },
      {
        path: "/policy-house-main",
        name: "policyHouseMain",
        component: () => import("@/views/Policy/housemain.vue"),
        meta: ["100%契税补贴"],
      },
      {
        path: "/talent-window",
        name: "talentWindow",
        component: () => import("@/views/Policy/talentwindow.vue"),
        meta: ["100%契税补贴"],
      },
      // 购房补贴政策管理
      //住建局
      {
        path: "/purchase",
        name: "purchaseIndex",
        component: () => import("@/views/Purchase/index.vue"),
        meta: ["购房补贴政策管理"],
      },
      //四个部门
      {
        path: "/purchase-details",
        name: "purchaseDetails",
        meta: ["购房补贴政策管理"],
        component: () => import("@/views/Purchase/details"),
      },
      //人才窗口
      {
        path: "/purchase-windows",
        name: "purchaseWindows",
        meta: ["购房补贴政策管理"],
        component: () => import("@/views/Purchase/windows"),
      },
      // 冷链食品申报
      {
        path: "/coldfood",
        name: "coldFood",
        meta: ["冷链食品"],
        component: () => import("@/views/Coldfood/index.vue"),
      },
      // 冷链食品自主申报
      {
        path: "/selfreport",
        name: "selfReport",
        meta: ["冷链食品"],
        component: () => import("@/views/Coldfood/selfReport"),
      },
      // 冷链食品数据统计
      {
        path: "/coldfood-statistics",
        name: "coldfoodStatistics",
        meta: ["冷链食品"],
        component: () => import("@/views/Coldfood/statistics"),
      },
      // 冷链食品商品流向分析
      {
        path: "/coldfood-flow",
        name: "coldfoodFlow",
        meta: ["冷链食品"],
        component: () => import("@/views/Coldfood/flowAnalysis"),
      },
      // 人才码
      {
        path: "/talents",
        name: "talents",
        meta: ["人才码申报管理"],
        component: () => import("@/views/Talents/index.vue"),
      },
      // 人才码
      {
        path: "/family-manage",
        name: "family",
        meta: ["家庭码"],
        component: () => import("@/views/FamilyManage/index.vue"),
      },
      // 通用管理
      // 登录用户管理
      {
        path: "/loginUser",
        name: "loginUser",
        meta: ["通用管理"],
        component: () => import("@/views/Currency/loginUser.vue"),
      },
      // 实名用户管理
      {
        path: "/realUser",
        name: "realUser",
        meta: ["通用管理"],
        component: () => import("@/views/Currency/realUser.vue"),
      },
      // 通行码管理
      {
        path: "/epidemic",
        name: "epidemic",
        meta: ["通行码管理"],
        component: () => import("@/views/Epidemic/index.vue"),
      },
      // 采样码管理
      {
        path: "/nucleicAcid",
        name: "nucleicAcid",
        meta: ["采样码管理"],
        component: () => import("@/views/NucleicAcid/index.vue"),
      },
      // 抗原管理
      {
        path: "/antigen",
        name: "antigen",
        meta: ["抗原管理"],
        component: () => import("@/views/Antigen/index.vue"),
      },
      // 核酸采样结果
      {
        path: "/nucleicAcidResult",
        name: "nucleicAcidResult",
        meta: ["核酸采样结果"],
        component: () => import("@/views/NucleicAcid/result.vue"),
      },
      // 便民生活圈
      {
        path: "/livingCircle/serviceType",
        name: "serviceType",
        meta: ["服务类型管理"],
        component: () => import("@/views/livingCircle/serviceType.vue"),
      },
      {
        path: "/livingCircle/searchTerms",
        name: "serviceType",
        meta: ["推荐搜索词管理"],
        component: () => import("@/views/livingCircle/searchTerms.vue"),
      },
      {
        path: "/livingCircle/serviceInfo",
        name: "serviceType",
        meta: ["服务信息管理"],
        component: () => import("@/views/livingCircle/serviceInfo.vue"),
      },
      {
        path: "/livingCircle/enter",
        name: "enter",
        meta: ["商家入驻审核"],
        component: () => import("@/views/livingCircle/enter.vue"),
      },
      {
        path: "/livingCircle/report",
        name: "report",
        meta: ["市民上报审核"],
        component: () => import("@/views/livingCircle/report.vue"),
      },
      {
        path: "/livingCircle/help",
        name: "help",
        meta: ["邻里求助审核"],
        component: () => import("@/views/livingCircle/help.vue"),
      },
      {
        path: "/livingCircle/helpInfo",
        name: "helpInfo",
        meta: ["邻里求助信息管理"],
        component: () => import("@/views/livingCircle/helpInfo.vue"),
      },
    ],
  },
];
const router = new VueRouter({
  mode: "hash",
  base: process.env.BASE_URL,
  routes,
});
const routerPush = VueRouter.prototype.push;
VueRouter.prototype.push = function push(location) {
  return routerPush.call(this, location).catch((error) => error);
};
export default router;
