import {
    api,
    formatParams
} from "@/utils/axios";
// import {
//     api1,
//     formatParams1,
//     config
// } from '@/utils/request'

/**
 * 购房契税补贴住建局审核申请列表
 * @param {*} params 
 * @returns 
 */
export function mattersHouseList(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/house/mattersHouseList`
    }))
}

/**
 * 购房补贴查询详情
 */
export function mattersHouseGetInfo(params) {
    return api(Object.assign(formatParams('GET', params), {
        url: `/admin-api/house/mattersHouseGetInfo`
    }))
}

/**
 * 购房契税补贴四个部门审核申请列表
 * @param {*} params 
 * @returns 
 */
export function mattersHouseReviewerList(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/house/mattersHouseReviewerList`
    }))
}

/**
 * 购房补贴4个初审部门通过
 */
export function mattersHouseReviewerPass(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/house/mattersHouseReviewerPass`
    }))
}

/**
 * 购房补贴4个初审部门拒绝
 */
export function mattersHouseReviewerReject(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/house/mattersHouseReviewerReject`
    }))
}


/**
 * 购房补贴4个初审部门操作记录
 */
export function mattersHouseRevieweReason(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/house/mattersHouseReviewerReason`
    }))
}

/**
 * 购房补贴住建局操作记录
 */
export function mattersHouseReason(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/house/mattersHouseReason`
    }))
}

/**
 * 购房补贴申请员工列表
 */
export function mattersHouseStaffList(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/house/mattersHouseStaffList`
    }))
}

/**
 * 购房补贴住建局拒绝
 */
export function mattersHouseReject(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/house/mattersHouseReject`
    }))
}

/**
 * 购房补贴住建局通过
 */
export function mattersHousePass(params) {
    return api(Object.assign(formatParams('POST', params), {
        url: `/admin-api/house/mattersHousePass`
    }))
}

/**
 * 查询附件
 */
 export function queryAttacheFile(params) {
    return api(Object.assign(formatParams('GET', params), {
        url: `/admin-api/house/queryAttacheFile`
    }))
}